/** Implementation of NSCopyObject() for GNUStep
   Copyright (C) 1994, 1995 Free Software Foundation, Inc.

   Written by:  Andrew Kachites McCallum <mccallum@gnu.ai.mit.edu>
   Date: August 1994

   This file is part of the GNUstep Base Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111 USA.

   <title>NSCopyObject class reference</title>
   $Date: 2006-02-11 11:22:57 -0700 (Sat, 11 Feb 2006) $ $Revision$
   */

#include "config.h"
#include "GNUstepBase/preface.h"
#include "Foundation/NSObject.h"

NSObject *NSCopyObject(NSObject *anObject, unsigned extraBytes, NSZone *zone)
{
  id copy = NSAllocateObject(((id)anObject)->class_pointer, extraBytes, zone);
  memcpy(copy, anObject,
	 ((id)anObject)->class_pointer->instance_size + extraBytes);
  return copy;
}
