/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 */

#include "../modutils.h"

module modinfo;

module *
module_new() {
    MODULE_INIT(&modinfo, 
		"Reverse",
		"Pascal Haakmat",
		"Copyright (C) 2002,2003");
    return &modinfo;
}

action_group *
module_execute(shell *shl, 
               int undo) {
    int t, map = shl->select_channel_map;
    AFframecount start = shl->select_start, end = shl->select_end;

    rwlock_rlock(&shl->sr->rwl);
    for(t = 0; t < snd_track_count(shl->sr); t++) {
        if((1 << t) & map) {
            reverse(shl,
                    t,
                    start,
                    end);
        }
    }
    rwlock_runlock(&shl->sr->rwl);
    return NULL;
}
