/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef ACTION_H
#define ACTION_H

#include <audiofile.h>
#include "snd.h"
#include "shell.h"

#define test_flag(state, flag) \
  (((state) & (flag)) == (flag))
#define set_flag(state, flag) \
  ((state) |= (flag))
#define clear_flag(state, flag) \
  ((state) &= ~(flag))

typedef enum {
    ACTION_SAVE_IN_PROGRESS           = (1 << 0),
    ACTION_LOAD_IN_PROGRESS           = (1 << 1),
    ACTION_MODULE_EXECUTE_IN_PROGRESS = (1 << 2),
    ACTION_PLAYER_INIT_IN_PROGRESS    = (1 << 3)
} action_state_flags;

typedef enum {
    ACTION_FILE_NEW,
    ACTION_FILE_INIT,
    ACTION_FILE_SELECT,
    ACTION_FILE_OPEN,
    ACTION_FILE_SAVE,
    ACTION_FILE_SAVE_AS,
    ACTION_FILE_MIXDOWN,
    ACTION_FILE_CLOSE,
    ACTION_INSERT,
    ACTION_ERASE,
    ACTION_DELETE,
    ACTION_DELETE_ON_TRACK,
    ACTION_CUT,
    ACTION_PASTE,
    ACTION_PASTE_OVER,
    ACTION_PASTE_MIX,
    ACTION_PASTE_FIT,
    ACTION_SELECT,
    ACTION_COPY,
    ACTION_TRACKS_INSERT,
    ACTION_TRACKS_DELETE,
    ACTION_SELECTION_FIT,
    ACTION_SELECTION_TO_LOOP,
    ACTION_LOOP_TO_SELECTION,
    ACTION_PLAYER_PLAY,
    ACTION_PLAYER_STOP,
    ACTION_MODULE_OPEN,
    ACTION_MODULE_EXECUTE,
    ACTION_MARKER_LIST_INSERT,
    ACTION_MARKER_LIST_DELETE,
    ACTION_EXIT,
    ACTION_LAST
} action_id;

typedef struct _action {
    action_id id;
    shell *shl;
    struct marker_list **m_source;
    struct marker_list **m_target;
    enum marker_type m_type;
    int m_time;
    snd *sr_source;
    snd *sr_target;
    track_map_t channel_map;
    AFframecount offset;
    AFframecount count;
    int undo;
    int suppress_redraw;
    int in_group;
    char *str;
} action;

typedef struct {
    int count;
    action *a[1];
} action_group;

typedef struct {
    char *name;
    action_group *(*func)(action *);
    int signature;
} action_desc;

typedef struct {
    int id;
    int defined;
    action_group *undo;
    void *val;
} action_result;

#define HAS_TARGET        (1 <<  0)
#define HAS_SOURCE        (1 <<  1)
#define HAS_SHELL         (1 <<  2)
#define HAS_MAP           (1 <<  3)
#define HAS_OFFSET        (1 <<  4)
#define HAS_COUNT         (1 <<  5)
#define HAS_MODULE_INDEX  (1 <<  6)
#define HAS_TRACK_INDEX   (1 <<  7)
#define HAS_MARKER_SOURCE (1 <<  8)
#define HAS_MARKER_TARGET (1 <<  9)
#define HAS_MARKER_TYPE   (1 << 10)
#define HAS_STRING        (1 << 11)
#define NULL_SOURCE       (1 << 12)
#define HAS_SEL_SPEC      (HAS_MAP | HAS_OFFSET | HAS_COUNT)

#define DONT_UNDO 0
#define WITH_UNDO 1

#define ACTION_RESULT (&last_action_result)

#define ACTION_RESULT_RETURN_PTR(id, shl) \
(action_result_ptr_set(&last_action_result, (id), (shl)))

#define ACTION_RESULT_RETURN_BOOL(id, v) \
(action_result_bool_set(&last_action_result, (id), (v)))

#define ACTION_RESULT_UNDO_SET(undo) \
(action_result_undo_set(&last_action_result, (undo)))

#define ACTION_RESULT_INIT(id) \
(action_result_init(&last_action_result, (id)))

#define ACTION_EXIT_NEW() \
action_new(ACTION_EXIT, NULL, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_MARKER_LIST_INSERT_TIME_NEW(u, shl, target, chmap, off, count, type) \
action_new(ACTION_MARKER_LIST_INSERT, shl, target, NULL, type, NULL, NULL, chmap, off, count, NULL, u) 

#define ACTION_MARKER_LIST_INSERT_NEW(u, shl, target, source, chmap, off, count, type) \
action_new(ACTION_MARKER_LIST_INSERT, shl, target, source, type, NULL, NULL, chmap, off, count, NULL, u) 

#define ACTION_MARKER_LIST_DELETE_NEW(u, shl, target, chmap, off, count, type) \
action_new(ACTION_MARKER_LIST_DELETE, shl, target, NULL, type, NULL, NULL, chmap, off, count, NULL, u) 

#define ACTION_MODULE_EXECUTE_NEW(u, shl, module_index) \
action_new(ACTION_MODULE_EXECUTE, shl, NULL, NULL, -1, NULL, NULL, module_index, -1, -1, NULL, u) 

#define ACTION_MODULE_OPEN_NEW(u, shl, module_index) \
action_new(ACTION_MODULE_OPEN, shl, NULL, NULL, -1, NULL, NULL, module_index, -1, -1, NULL, u) 

#define ACTION_PLAYER_PLAY_NEW(shl) \
action_new(ACTION_PLAYER_PLAY, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_PLAYER_STOP_NEW(shl) \
action_new(ACTION_PLAYER_STOP, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_LOOP_TO_SELECTION_NEW(shl) \
action_new(ACTION_LOOP_TO_SELECTION, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_SELECTION_TO_LOOP_NEW(shl) \
action_new(ACTION_SELECTION_TO_LOOP, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_SELECTION_FIT_NEW(shl) \
action_new(ACTION_SELECTION_FIT, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_SELECT_NEW() \
action_new(ACTION_FILE_SELECT, NULL, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_OPEN_NEW(shl, filename) \
action_new(ACTION_FILE_OPEN, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, filename, DONT_UNDO) 

#define ACTION_FILE_NEW_NEW() \
action_new(ACTION_FILE_NEW, NULL, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_INIT_NEW(shl) \
action_new(ACTION_FILE_INIT, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_SAVE_NEW(shl) \
action_new(ACTION_FILE_SAVE, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_SAVE_AS_NEW(shl) \
action_new(ACTION_FILE_SAVE_AS, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_MIXDOWN_NEW(shl) \
action_new(ACTION_FILE_MIXDOWN, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_FILE_CLOSE_NEW(shl) \
action_new(ACTION_FILE_CLOSE, shl, NULL, NULL, -1, NULL, NULL, -1, -1, -1, NULL, DONT_UNDO) 

#define ACTION_TRACKS_DELETE_NEW(u, shl, sr, chmap) \
action_new(ACTION_TRACKS_DELETE, shl, NULL, NULL, -1, sr, NULL, chmap, -1, -1, NULL, u) 

#define ACTION_TRACKS_INSERT_NEW(u, shl, sr, ins_sr, chmap) \
action_new(ACTION_TRACKS_INSERT, shl, NULL, NULL, -1, sr, ins_sr, chmap, -1, -1, NULL, u) 

#define ACTION_COPY_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_COPY, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_SELECT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_SELECT, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_PASTE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_PASTE_OVER_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_OVER, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_PASTE_MIX_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_MIX, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_PASTE_FIT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_FIT, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u) 

#define ACTION_CUT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_CUT, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u)

#define ACTION_INSERT_NEW(u, sr, ins_sr, chmap, off) \
action_new(ACTION_INSERT, NULL, NULL, NULL, -1, sr, ins_sr, chmap, off, -1, NULL, u)

#define ACTION_ERASE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_ERASE, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u)

#define ACTION_DELETE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_DELETE, shl, NULL, NULL, -1, sr, NULL, chmap, off, count, NULL, u)

/* FIXME: this action is needed because we cannot make per-track
   selections. */

#define ACTION_DELETE_ON_TRACK_NEW(u, shl, sr, track_index, off, count) \
action_new(ACTION_DELETE_ON_TRACK, shl, NULL, NULL, -1, sr, NULL, track_index, off, count, NULL, u)

action *
action_new(action_id id,
           shell *shl,
           struct marker_list **m_target,
           struct marker_list **m_source,
           enum marker_type m_type,
           snd *sr_target,
           snd *sr_source,
           track_map_t channel_map,
           AFframecount offset,
           AFframecount count,
           const char *s,
           int undo);


action_group *
action_group_new(int count, ...);

action_group *
action_group_new_empty(int count);
 
action_group *
action_group_append(action_group *ag,
                    action *a);

action_group *
action_group_undo_create(shell *shl,
                         track_map_t channel_map,
                         AFframecount frame_offset,
                         AFframecount frame_count,
                         AFframecount delete_frame_offset,
                         AFframecount delete_frame_count);

void
action_result_undo_set(action_result *ar,
                       action_group *undo);
 
action_result *
action_do(action *a);

void
action_group_do(action_group *ag);

void
action_group_destroy(action_group *ag);

void
action_destroy(action *a);

void
action_result_bool_set(action_result *ar,
                       action_id id,
                       gboolean b);

void
action_result_ptr_set(action_result *ar,
                      action_id id,
                      void *ptr);

gboolean
action_result_as_bool(action_result *ar);

void *
action_result_as_ptr(action_result *ar);

void
action_result_init(action_result *ar,
                   action_id id);

#endif
