#!/usr/bin/env python
#
# Copyright 2011 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

from xml.dom import minidom

def make_proccpu_sim(dom) :
    tempstring = "";
    tempstring = tempstring + "/*this file is auto_generated by volk_register.py*/\n\n";
    tempstring = tempstring + "#include <volk/volk_cpu.h>\n"
    tempstring = tempstring + "#include <stdio.h>\n"
    tempstring = tempstring + "\n\n"

    tempstring = tempstring + "void test_append(char* buf,  int val, char* newkey){\n";
    tempstring = tempstring + "    if(val==1){\n";
    tempstring = tempstring + "        sprintf(buf, \"%s %s\", buf, newkey);\n";
    tempstring = tempstring + "    }\n";
    tempstring = tempstring + "}\n";
    tempstring = tempstring + "\n\n";
    
    tempstring = tempstring + "int main() {\n";
    tempstring = tempstring + "    volk_cpu_init();\n";
    tempstring = tempstring + "    char buf[2048];\n";
    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        tempstring = tempstring + "    test_append(buf, volk_cpu.has_" + arch + "(), \"" + arch + "\");\n"
    tempstring = tempstring + "    printf(\"%s\\n\", buf);\n"
    tempstring = tempstring + "}\n"
    return tempstring;
