/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/upload.h
 * @brief code for uploading with gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_UPLOAD_H
#define GTK_UPLOAD_H

/**
 */
void displayUploadUpdate(const char * mainName,
			 const char * filename,
			 unsigned long long completed,
			 unsigned long long total);

/**
 */
void displayUploadComplete(const char * mainName,
			   const char * filename,
			   const struct ECRS_URI * uri);



/**
 * Add the given result to the model (upload result
 * list).
 * @param info the information to add to the model
 * @param uri the upload URI
 * @param path the tree path that selects where to add
 *        the information, NULL for top-level
 */
void displayUploadResult(const ECRS_FileInfo * info,
			 const struct ECRS_URI * uri,
			 GtkTreeRowReference * row);

void fs_upload_start(void);

void fs_upload_stop(void);

#endif
