/*
**  ExtendedAttachmentCell.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#import "ExtendedAttachmentCell.h"

#import "GNUMailConstants.h"

#import <Pantomime/Part.h>

@implementation ExtendedAttachmentCell

- (id) initWithFilename: (NSString *) theFilename
		   size: (int) theSize
{
  NSMutableDictionary *attributes;
  NSString *aString;

  self = [super init];

  [self setPart: nil];
  
  // We create our string that we'll display under the attachment cell
  if ( (theSize / 1024) == 0 )
    {
      aString = [NSString stringWithFormat: _(@"%@ (%d bytes)"), theFilename, theSize];
    }
  else
    {
      aString = [NSString stringWithFormat: _(@"%@ (%d KB)"), theFilename, theSize/1024];
    }
  
  // We create a set of attributes (base font, color red)
  attributes = [[NSMutableDictionary alloc] init];
  [attributes setObject: [NSColor redColor]
	      forKey: NSForegroundColorAttributeName];
  
  attributedString = [[NSAttributedString alloc] 
		       initWithString: aString
		       attributes: attributes];
  
  RELEASE(attributes);

  return self;
}

- (void) dealloc
{
  RELEASE(attributedString);

  TEST_RELEASE(part);

  [super dealloc];
}

- (NSSize) cellSize
{
  NSSize aSize;
  
  aSize = [super cellSize];
  
  aSize.height += 15;
  
  if (aSize.width < [attributedString size].width)
    {
      aSize.width = [attributedString size].width;
    }

  return aSize;
}

- (void) drawWithFrame: (NSRect) cellFrame 
		inView: (NSView *) controlView
{
  int delta;
  
  cellFrame.origin.y -= 7.5;
  [super drawWithFrame: cellFrame inView: controlView];
  
  if ( [self cellSize].width > [attributedString size].width )
    {
      delta = ([self cellSize].width/2) - ([attributedString size].width/2);
    }
  else
    {
      delta = 0;
    }
  
  [controlView lockFocus];

  [attributedString drawInRect: NSMakeRect(cellFrame.origin.x + delta, 
                                           cellFrame.origin.y + 
					   cellFrame.size.height - 5,
                                           cellFrame.size.width,
                                           15) ];

  [controlView unlockFocus];
}


//
// access/mutation methods
//
- (Part *) part
{
  return part;
}

- (void) setPart: (Part *) thePart
{
  if ( thePart )
    {
      RETAIN(thePart);
      RELEASE(part);
      part = thePart;
    }
  else
    {
      RELEASE(part);
      part = nil;
    }
}

@end
