/*
**  ReceivingViewController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

#import "PreferencesModule.h"

@interface ReceivingViewController : NSObject <PreferencesModule>
{
  // Outlets
  IBOutlet id view;
 
  IBOutlet NSTextField *mailspoolFileField;
  IBOutlet NSTextField *minutesField;
  IBOutlet NSMatrix *matrix;
  
  IBOutlet NSButton *mailspoolFileButton;
  IBOutlet NSButton *transferFromMailspoolFile;
  IBOutlet NSButton *compactMailboxButton;
  IBOutlet NSButton *showFilterPanelButton;

  IBOutlet NSTableView *tableView;

  // Other ivars
  NSMutableDictionary *allServers;
}

//
// action methods
//

- (IBAction) add: (id) sender;
- (IBAction) edit: (id) sender;
- (IBAction) delete: (id) sender;

- (IBAction) setEnabledFields: (id) sender;

- (IBAction) setManually: (id) sender;
- (IBAction) setAutomatically: (id) sender;

- (IBAction) getMailspoolFile: (id) sender;

//
// other methods
//
- (void) updateServersList;

@end
