/*
**  ReceivingView.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "ReceivingView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

const id IncomingServersColumnIdentifier = @"incoming servers";

@implementation ReceivingView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}

- (void) layoutView
{
  NSButton *add, *edit, *delete;
  LabelWidget *minutesLabel, *mailspoolFileLabel;
  NSButtonCell *cell;
  NSBox *box;
  NSScrollView *scrollView;
  NSTableColumn *serversColumn;

  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,270,430,75)];
  [box setContentViewMargins: NSMakeSize(0,0)];
  AUTORELEASE(box);
  [box setTitle: _(@"Retrieve mail (for POP3 accounts and local mail spool file)")];
  [box setBorderType:NSGrooveBorder];
  
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSRadioButton];
  [cell setBordered: NO];
  [cell setImagePosition: NSImageLeft];

  matrix = [[NSMatrix alloc] initWithFrame:NSMakeRect(5,5,145,50)
			     mode: NSRadioModeMatrix
			     prototype: cell
			     numberOfRows: 2
			     numberOfColumns: 1];
  [matrix setTarget: parent];
  [matrix setIntercellSpacing: NSMakeSize (0, 5) ];
  [matrix setAutosizesCells: NO];
  [matrix setAllowsEmptySelection: NO];
  
  cell = [matrix cellAtRow: 0 column: 0];
  [cell setTitle: _(@"Manually")];
  [cell setAction: @selector(setManually:)];

  cell = [matrix cellAtRow: 1 column: 0];
  [cell setTitle: _(@"Automatically every")];
  [cell setAction: @selector(setAutomatically:)];
  [matrix sizeToFit];  
  
  [[box contentView] addSubview: matrix];

  minutesField = [[NSTextField alloc] initWithFrame:NSMakeRect(160,5,40,TextFieldHeight)];
  [minutesField setEditable: NO];
  [minutesField setSelectable: YES];
  [[box contentView] addSubview:minutesField];
    
  minutesLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(205,5,50,TextFieldHeight)
			      label: _(@"minutes")];
  [[box contentView] addSubview:minutesLabel];

  [self addSubview:box];


  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,130,430,130)];
  AUTORELEASE(box);
  [box setTitlePosition:NSAtTop];
  [box setTitle: _(@"Incoming mail servers")];
  [box setBorderType:NSGrooveBorder];
  
  serversColumn = [[NSTableColumn alloc] initWithIdentifier: IncomingServersColumnIdentifier];
  AUTORELEASE(serversColumn);
  [serversColumn setEditable: NO];
  [[serversColumn headerCell] setStringValue: _(@"Incoming Servers")];
  [serversColumn setMinWidth: 255];
  
  tableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,5,320,90)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: serversColumn];
  [tableView setDataSource: parent];
  [tableView setDelegate: parent];
  [tableView setTarget: parent];
  [tableView setDoubleAction: @selector(edit:)];
  
  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,5,320,90)];
  [scrollView setHasHorizontalScroller:NO];
  [scrollView setHasVerticalScroller:YES];
  [scrollView setDocumentView:tableView];
  [[box contentView] addSubview:scrollView];
  
  add = [[NSButton alloc] initWithFrame: NSMakeRect(335,65,75,ButtonHeight)];
  [add setTitle: _(@"Add")];
  [add setTarget: parent];
  [add setAction: @selector(add:)];
  [box addSubview: add];
  RELEASE(add);
  
  edit = [[NSButton alloc] initWithFrame: NSMakeRect(335,35,75,ButtonHeight)];
  [edit setTitle: _(@"Edit")];
  [edit setTarget: parent];
  [edit setAction: @selector(edit:)];
  [box addSubview: edit];
  RELEASE(edit);
  
  delete = [[NSButton alloc] initWithFrame: NSMakeRect(335,5,75,ButtonHeight)];
  [delete setTitle: _(@"Delete")];
  [delete setTarget: parent];
  [delete setAction: @selector(delete:)];
  [box addSubview: delete];
  [self addSubview: box];
  RELEASE(delete);
  
  transferFromMailspoolFile = [[NSButton alloc] initWithFrame: NSMakeRect(5,95,240,ButtonHeight)];
  [transferFromMailspoolFile setButtonType: NSSwitchButton];
  [transferFromMailspoolFile setBordered: NO];
  [transferFromMailspoolFile setTitle: _(@"Transfer from mail spool file")];
  [transferFromMailspoolFile setTarget: parent];
  [transferFromMailspoolFile setAction: @selector(setEnabledFields:)];
  [self addSubview: transferFromMailspoolFile];
  
  mailspoolFileLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,65,100,TextFieldHeight)
				    label: _(@"Mail spool file:")];
  [self addSubview:mailspoolFileLabel];

  mailspoolFileField = [[NSTextField alloc] initWithFrame: NSMakeRect(120,65,240,TextFieldHeight)];
  [mailspoolFileField setEditable:YES];
  [mailspoolFileField setSelectable:YES];
  [self addSubview:mailspoolFileField];
  
  mailspoolFileButton = [[NSButton alloc] initWithFrame: NSMakeRect(370,65,65,ButtonHeight)];
  [mailspoolFileButton setTitle: _(@"Choose")];
  [mailspoolFileButton setTarget: parent];
  [mailspoolFileButton setAction: @selector(getMailspoolFile:)];
  [self addSubview:mailspoolFileButton];

  
  compactMailboxButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,35,420,ButtonHeight)];
  [compactMailboxButton setButtonType: NSSwitchButton];
  [compactMailboxButton setBordered: NO];
  [compactMailboxButton setTitle: _(@"Compact mailbox when closing (not recommended)")];
  [compactMailboxButton setTarget: parent];
  [compactMailboxButton setAction: @selector(setEnabledFields:)];
  [self addSubview: compactMailboxButton];


  showFilterPanelButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,420,ButtonHeight)];
  [showFilterPanelButton setButtonType: NSSwitchButton];
  [showFilterPanelButton setBordered: NO];
  [showFilterPanelButton setTitle: _(@"Show Filter alert panel (for received and transferred messages)")];
  [showFilterPanelButton setTarget: parent];
  [showFilterPanelButton setAction: @selector(setEnabledFields:)];
  [self addSubview: showFilterPanelButton];
  
}

- (void) dealloc
{
  //NSLog(@"ReceivingView: -dealloc");
  
  RELEASE(transferFromMailspoolFile);
  RELEASE(mailspoolFileButton);
  RELEASE(compactMailboxButton);
  RELEASE(showFilterPanelButton);

  RELEASE(minutesField);
  RELEASE(matrix);

  RELEASE(tableView);

  [super dealloc];
}


//
// access methods
//

- (NSTextField *) mailspoolFileField
{
  return mailspoolFileField;
}


- (NSTextField *) minutesField
{
  return minutesField;
}

- (NSMatrix *) matrix
{
  return matrix;
}


- (NSButton *) mailspoolFileButton
{
  return mailspoolFileButton;
}


- (NSButton *) transferFromMailspoolFile
{
  return transferFromMailspoolFile;
}

- (NSButton *) compactMailboxButton
{
  return compactMailboxButton;
}

- (NSButton *) showFilterPanelButton
{
  return showFilterPanelButton;
}

- (NSTableView *) tableView
{
  return tableView;
}


@end
