/*
**  IMAPView.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "IMAPView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

const NSString *IMAPViewTableColumnIdentifier = @"subscribed folders";

@implementation IMAPView

- (void) initUI
{
  LabelWidget *retrieveMinutesLabel, *minutesLabel;
  NSButton *subscribe, *unsubscribe;
  NSScrollView *scrollView;
  NSTableColumn *tableColumn;
  
  transferToLocalTrash = [[NSButton alloc] initWithFrame: NSMakeRect(5,175,340,ButtonHeight)];
  [transferToLocalTrash setButtonType: NSSwitchButton];
  [transferToLocalTrash setBordered: NO];
  [transferToLocalTrash setTitle: _(@"When deleting a message, transfer to Local Trash folder")];
  [self addSubview: transferToLocalTrash];

  retrieveMinutesLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,150,130,TextFieldHeight)
				      label: _(@"Check for mail every")];
  [self addSubview: retrieveMinutesLabel];

  retrieveMinutesField = [[NSTextField alloc] initWithFrame: NSMakeRect(140,150,130,TextFieldHeight)];
  [retrieveMinutesField setEditable: YES];
  [retrieveMinutesField setSelectable: YES];
  [self addSubview: retrieveMinutesField];

  minutesLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(280,150,70,TextFieldHeight)
			      label: _(@"minutes")];
  [self addSubview: minutesLabel];
  
  tableColumn = [[NSTableColumn alloc] initWithIdentifier: (id) IMAPViewTableColumnIdentifier];
  AUTORELEASE(tableColumn);
  [tableColumn setEditable: NO];
  [[tableColumn headerCell] setStringValue: _(@"Subscribed Folders")];
  [tableColumn setMinWidth: 340];

  tableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,40,340,100)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: tableColumn];
  [tableView setDataSource: self]; 
  [tableView setDelegate: self];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,40,340,100)];
  AUTORELEASE(scrollView);
  [scrollView setHasHorizontalScroller:NO];
  [scrollView setDocumentView:tableView];
  [self addSubview: scrollView];
  
  subscribe = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,100,ButtonHeight)];
  AUTORELEASE(subscribe);
  [subscribe setTitle: _(@"Subscribe")];
  [subscribe setTarget:self];
  [subscribe setAction:@selector(subscribe:)];
  [self addSubview: subscribe];

  unsubscribe = [[NSButton alloc] initWithFrame: NSMakeRect(110,5,100,ButtonHeight)];
  AUTORELEASE(unsubscribe);
  [unsubscribe setTitle: _(@"Unsubscribe")];
  [unsubscribe setTarget:self];
  [unsubscribe setAction:@selector(unsubscribe:)];
  [self addSubview: unsubscribe];
}

- (void) dealloc
{
  //NSLog(@"IMAPView: -dealloc");

  RELEASE(transferToLocalTrash);
  RELEASE(tableView);
  
  [super dealloc];
}


//
// deletage methods
//


- (id)           tableView: (NSTableView *) aTableView
 objectValueForTableColumn: (NSTableColumn *) aTableColumn
                       row:(int) rowIndex
{
  return @"";
}

- (int) numberOfRowsInTableView: (NSTableView *) aTableView
{
  return 0;
}

- (void) subscribe: (id) sender
{
  NSLog(@"subscribe");
  NSRunInformationalAlertPanel(_(@"Feature not implemented!"),
			       _(@"This feature is going to be implemented soon."),
			       _(@"OK"),
			       NULL,
			       NULL,
			       NULL);
}

- (void) unsubscribe: (id) sender
{
  NSLog(@"unsubscribe");
  NSRunInformationalAlertPanel(_(@"Feature not implemented!"),
			       _(@"This feature is going to be implemented soon."),
			       _(@"OK"),
			       NULL,
			       NULL,
			       NULL);
}


//
//
//
- (NSButton *) transferToLocalTrash
{
  return transferToLocalTrash;
}


//
//
//
- (NSTextField *) retrieveMinutesField
{
  return retrieveMinutesField;
}

@end
