#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# templates/__init__.py
#
# DESCRIPTION:
# Base template directory
#
# NOTES:
#

import os, string, dircache
from gnue.common.utils.FileUtils import dyn_import

#################################################################
#
# Returns a list of <modules> containing templates.
# To get the wizards available in a template, call
# GetAvailableTemplates(<module>)
#
#################################################################

def GetAvailablePackages():
  packages = []
  Tools = (
    'navigator',
    'forms',
    'reports',
    'schema')
  
  for tool in Tools:
      try:
        packages.append(dyn_import('gnue.designer.templates.%s' %tool))
      except ImportError:
        pass

  return packages


#################################################################
#
# Return a list of the TemplateInformation dictionaries for all
# available templates in the specified <module> (package).
#
#################################################################

def GetAvailableTemplates(package):
  templates = []

  basedir = os.path.dirname(package.__file__)
  processed = []  # Base file names processed (e.g., base of Simply.py*
                # is Simple) This will keep us from importing Simple
                # three times if Simple.py, Simple.pyc, and Simple.lib
                # all exist.

  for dir in dircache.listdir(basedir):
    base = string.split(dir,'.')[0]
    if not dir[0] in ('.','_') and not base in processed:
      processed.append(base)
      try:
        templates.append(dyn_import(
           '%s.%s' % (package.__name__,base)).TemplateInformation)
      except ImportError:
        pass
  return templates
