#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# WidgetHighlighter.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from Utils import *
from gnue.common.apps import GDebug

inactiveBorderColor = wxBLACK
activeBorderColor = wxBLUE

#
#
#
class WidgetHighlighter:

  def __init__(self, parent):
    self.selected = 0
    self.focused = 0
    self.parent = parent
    self.x1 = 1
    self.y1 = 1
    self.x2 = 2
    self.y2 = 2
    self.west = None
    self.east = None
    self.north = None
    self.south = None
    self.westb = None
    self.eastb = None
    self.northb = None
    self.southb = None


  # Draw the lines comprising the highlights
  def createHighlights(self):
    if self.north:
      self.Destroy()

    self.northb = wxWindow(self.parent, -1)
    self.southb = wxWindow(self.parent, -1)
    self.eastb = wxWindow(self.parent, -1)
    self.westb = wxWindow(self.parent, -1)
    for object in (self.northb,self.southb,self.eastb,self.westb):
      EVT_PAINT(object, self.OnPaintBorder)


    self.north = wxWindow(self.parent, -1)
    self.south = wxWindow(self.parent, -1)
    self.east = wxWindow(self.parent, -1)
    self.west = wxWindow(self.parent, -1)
    for object in (self.north,self.south,self.east,self.west):
      EVT_PAINT(object, self.OnPaint)



    self.setBoundary(self.x1, self.y1, self.x2, self.y2)


  # Delete the lines comprising the highlights
  def deleteHighlights(self):
    if self.west:
      self.west.Destroy()
    if self.east:
      self.east.Destroy()
    if self.north:
      self.north.Destroy()
    if self.south:
      self.south.Destroy()
    self.west = None
    self.east = None
    self.north = None
    self.south = None

    if self.westb:
      self.westb.Destroy()
    if self.eastb:
      self.eastb.Destroy()
    if self.northb:
      self.northb.Destroy()
    if self.southb:
      self.southb.Destroy()
    self.westb = None
    self.eastb = None
    self.northb = None
    self.southb = None


  def setBoundaryXXXXXX(self, x1, y1, x2, y2):
     self.x1 = x1
     self.y1 = y1
     self.x2 = x2
     self.y2 = y2

     if self.west:
       self.west.SetPosition(wxPoint(x1,y1))
       self.west.SetSize(wxSize(2,y2-y1+2))
     if self.east:
       self.east.SetPosition(wxPoint(x2,y1))
       self.east.SetSize(wxSize(2,y2-y1+2))
     if self.south:
       self.south.SetPosition(wxPoint(x1,y2))
       self.south.SetSize(wxSize(x2-x1+2,2))
     if self.north:
       self.north.SetPosition(wxPoint(x1,y1))
       self.north.SetSize(wxSize(x2-x1+2,2))


  def setBoundary(self, x1, y1, x2, y2):
     self.x1 = x1
     self.y1 = y1
     self.x2 = x2
     self.y2 = y2

     mx = (x2 - x1)/2 + x1 - 1
     my = (y2 - y1)/2 + y1 - 1

     if self.west:
       self.west.SetPosition(wxPoint(x1 - 3,my))
       self.west.SetSize(wxSize(4,4))
     if self.east:
       self.east.SetPosition(wxPoint(x2,my))
       self.east.SetSize(wxSize(4,4))
     if self.south:
       self.south.SetPosition(wxPoint(mx,y2))
       self.south.SetSize(wxSize(4,4))
     if self.north:
       self.north.SetPosition(wxPoint(mx,y1 - 3))
       self.north.SetSize(wxSize(4,4))

     if self.west:
       self.westb.SetPosition(wxPoint(x1,y1))
       self.westb.SetSize(wxSize(1,y2-y1+1))
     if self.east:
       self.eastb.SetPosition(wxPoint(x2,y1))
       self.eastb.SetSize(wxSize(1,y2-y1+1))
     if self.south:
       self.southb.SetPosition(wxPoint(x1,y2))
       self.southb.SetSize(wxSize(x2-x1+1,1))
     if self.north:
       self.northb.SetPosition(wxPoint(x1,y1))
       self.northb.SetSize(wxSize(x2-x1+1,1))


  def GetChildren(self):
    if self.west:
      return (self.north, self.south, self.east, self.west)
    else:
      return ()

  def Refresh(self):
    for object in (self.north,self.south,self.east,self.west):
      object.Refresh()

  def Destroy(self):
    self.deleteHighlights()

  def setSelected (self, selected, focused):
    if selected:
      self.selected = selected
      self.focused = focused
      self.createHighlights()
      self.Refresh()
    else:
      self.deleteHighlights()

  def reconfigure(self, event):
    self.Refresh()

  def OnPaintXXXX(self, event):
    object = wxPyTypeCast(event.GetEventObject(),'wxWindow')
    dc = wxPaintDC(object)
    dc.BeginDrawing()
    dc.SetBackground(wxBrush(self.parent.GetBackgroundColour(),wxTRANSPARENT))
    dc.Clear()
    if self.focused:
      dc.SetPen(wxPen(activeBorderColor))
    else:
      dc.SetPen(wxPen(inactiveBorderColor))
    x1,y1 = object.GetSizeTuple()
##    dc.DrawRectangle(0,0,x1,y1)
##    if self.focused:
##      dc.DrawRectangle(1,1,x1-2,y1-2)

    dc.EndDrawing()

  def OnPaint(self, event):
    if not self.focused: return
    object = wxPyTypeCast(event.GetEventObject(),'wxWindow')
    dc = wxPaintDC(object)
    dc.BeginDrawing()
##    dc.SetBackground(wxBrush(self.parent.GetBackgroundColour(),wxTRANSPARENT))
    if self.focused:
      dc.SetBackground(wxBrush(activeBorderColor,wxTRANSPARENT))
    else:
      dc.SetBackground(wxBrush(inactiveBorderColor,wxTRANSPARENT))

    dc.Clear()
##    if self.focused:
##      dc.SetPen(wxPen(activeBorderColor))
##    else:
##      dc.SetPen(wxPen(inactiveBorderColor))
##    x1,y1 = object.GetSizeTuple()
##    dc.DrawRectangle(0,0,x1,y1)
##    if self.focused:
##      dc.DrawRectangle(1,1,x1-2,y1-2)

    dc.EndDrawing()


  def OnPaintBorder(self, event):
    object = wxPyTypeCast(event.GetEventObject(),'wxWindow')
    dc = wxPaintDC(object)
    dc.BeginDrawing()
##    dc.SetBackground(wxBrush(self.parent.GetBackgroundColour(),wxTRANSPARENT))
    dc.SetBackground(wxBrush(wxBLACK,wxTRANSPARENT))
    dc.Clear()
##    if self.focused:
##      dc.SetPen(wxPen(activeBorderColor))
##    else:
##      dc.SetPen(wxPen(inactiveBorderColor))
##    x1,y1 = object.GetSizeTuple()
##    dc.DrawRectangle(0,0,x1,y1)
##    if self.focused:
##      dc.DrawRectangle(1,1,x1-2,y1-2)

    dc.EndDrawing()

  def OnEraseBackground(self, event):
    pass

