#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# Incubator.py
#
# DESCRIPTION:
# Creates objects to be added to the object
#
# NOTES:
#

from gnue.common.apps import GDebug
from gnue.common.definitions import GParserHelpers

class BaseIncubator:
  elements = {}

  ##
  ##  Reparent an object
  ##
  def reparentObject(self, rootObject, object, newParent):
    if object._parent == newParent:
      return

    # TODO


  ##
  ##  Create a new object
  ##
  def createObject(self, rootObject, tag,
           parent, attributes={}, select=1):


    GDebug.printMesg(3,'Creating a "%s" object' % tag)
    GDebug.printMesg(6,"Object's parent is %s" % parent)

    try:
      name = attributes['name']
    except KeyError:
      name = self.instance.getNextGenericName(tag)

    try:
      objclass = self.elements[tag]['BaseClass']
      if self.elements[tag].has_key('Attributes'):
        attrs = self.elements[tag]['Attributes']
      else:
        attrs = {}
    except KeyError:
      GDebug.printMesg(1, "Attempted to create a '%s', "
                          "but I don't know what to do!" % tag)
      return 1

    o = objclass(parent)
    GDebug.printMesg(10, 'Created %s' % o)

    # Add any GContent
    try:
      GParserHelpers.GContent(o, attributes['_content_'])
    except KeyError:
      pass

    # Pull default values for any attributes not supplied
    for attr in attrs.keys():
      if not attributes.has_key(attr):
        if attrs[attr].has_key('Default'):
          attributes[attr] = attrs[attr]['Typecast'](attrs[attr]['Default'])


    for attr in attributes.keys():
      if attrs.has_key(attr):
        o.__dict__[attr] = attributes[attr]
      else:
        self._handleUnknownAttribute(tag, o, attr, attributes[attr])

    o.name = name
    self.instance.nameMappings[o.name] = o
    o._buildObject()
    self.instance.dispatchEvent('ObjectCreated',object=o, originator=__name__)
    if select:
      self.instance.dispatchEvent('ObjectSelected',object=o, originator=__name__)
    return o

  ##
  ##  Delete an object
  ##
  def deleteObject(self, rootObject, object, newCurrentObject=None, firstRun=1):

    if firstRun:
      newCurrentObject = parent = object._parent

    for child in object._children:
      if not child._type == '_content_':
        self.deleteObject(rootObject, child, firstRun=0)

    self.instance.dispatchEvent('ObjectDeleted',object=object, originator=__name__)

    if firstRun:
      o = parent
      while o._parent:
        o._buildObject()
        o = o._parent

      if newCurrentObject:
        self.instance.dispatchEvent('ObjectSelected',object=object, originator=__name__)

        
  ##
  ##  Internal stuff
  ##

  def __init__(self, instance):
    self.instance = instance

    # Figure out tag dependencies
    self._calcDependencies()


  def _calcDependencies(self):
    self.elementMapping = elementMapping = {}
    elements = self.elements

    for tag in elements.keys():
      t = elements[tag]

      try:
        cascade = t['UsableBySiblings']
      except KeyError:
        cascade = 0

      if t.has_key('ParentTags'):
        parents = t['ParentTags']
      else:
        parents = None

      if parents != None:
        for parent in parents:
          try:
            elementMapping[parent].append(tag)
          except KeyError:
            elementMapping[parent] = [tag]

  def _handleUnknownAttribute(self, tag, object, attr, value):
    return

