#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001 Free Software Foundation
#
# FILE:
# _empty/DBdriver.py
#
# DESCRIPTION:
# Virtual database driver for a dataless/connectionless client
#
# NOTES:
# Primarily used by unbound forms blocks
#

from gnue.common import GDebug
import string
from gnue.common.GDataObjects import * 


###########################################################
#
# This is an empty data driver for connectionless clients
# (primarily used by forms)
# 
###########################################################
class NIL_DataObject (DataObject): 

  def __init__(self): 
    DataObject.__init__(self)
    self.triggerExtensions = TriggerExtensions(self)

  def _createResultSet(self, conditions={}, readOnly=0, masterRecordSet=None): 
    return NIL_ResultSet(self, masterRecordSet=masterRecordSet)

  # We don't do logins
  def getLoginFields(self): 
    return ()

  # We don't do connections (we are connectionless)
  def connect(self, connectData={}):
    self._postConnect()

  # We don't do commits
  def commit(self):
    pass

  # And we don't do rollbacks
  def rollback(self):
    pass



###########################################################
#
# 
# 
###########################################################
class NIL_ResultSet(ResultSet): 

  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None): 
    ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = NIL_RecordSet


  # Returns 1=DataObject has uncommitted changes 
  def isPending(self):
    return 0    # Empty DataObjects cannot have pending changes :)

  # Post changes to the database
  def post(self):
    # Leave this here in case (for some bizarro reason)
    # a bound dataobject uses us as a master
    for record in (self._cachedRecords): 
      record.post()

  # Returns 1=Field is bound to a database field
  def isFieldBound(self, fieldName):
    return 0

  # Load cacheCount number of new records
  def _loadNextRecord(self): 
    return 0


  # Create an empty record
  def _createEmptyRecord(self): 
    return self._recordSetClass(self)


###########################################################
# 
#
# 
###########################################################
class NIL_RecordSet (RecordSet): 

  def isPending(self):
    return 0

  # Post any changes to database
  def _postChanges(self): 
    return 1



#
#  Extensions to Trigger Namespaces
#  
class TriggerExtensions: 
  def __init__(self, connection): 
    self.__connection = connection



######################################
#
#  The following hashes describe 
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
# 
supportedDataObjects = { 
  'object': NIL_DataObject
}


