#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# GConfig.py
#
# DESCRIPTION:
# Class that loads the gnue.conf files so gnue apps can get
# default settings. 
#
# NOTES:
#
# HISTORY:
#

from GConfigParser import * 
import os, sys, string
from gnue.common import openResource
import GDebug
import GDataObjects
import GLoginHandler

TRUE = 1
FALSE = 0

_OPTION = {}

class _NOOPTION:
  pass

def get(varName, default=_NOOPTION):
  global _OPTION
  if _OPTION.has_key(string.lower(varName)) or default == _NOOPTION:
    return _OPTION[string.lower(varName)]
  else:
    GDebug.printMesg(1,"Returning default value %s for %s" % (varName, default))
    return default

class InvalidFormatError (StandardError):
  # Raised if the Connections Definition File is
  # in an unreadable format.
  pass


class GConfig:
  def __init__(self, application):

    self._application = application

    _success = FALSE

    GDebug.printMesg(1,'Application style: %s' % self._application)
    GDebug.printMesg(1,'Reading basic configuration')
    if os.environ.has_key('INSTALL_PREFIX'):
      location = os.environ['INSTALL_PREFIX']+'/etc/gnue.conf'
      try:
        self.readConfig(location)
        _success = TRUE
      except:
        GDebug.printMesg (1,'File not available')

    GDebug.printMesg(1,'Reading user configuration overrides')
    if os.environ.has_key('HOME'):
      location = os.environ['HOME']+'/.gnue/gnue.conf'
      try:
        self.readConfig(location)
        _success = TRUE
      except:
        GDebug.printMesg (1,'File not available')

    GDebug.printMesg(1,'Reading fixed system configuration')
    if os.environ.has_key('INSTALL_PREFIX'):
      location = os.environ['INSTALL_PREFIX']+'/etc/gnue.conf.fixed'
      try:
        self.readConfig(location)
        _success = TRUE
      except:
        GDebug.printMesg (1,'File not available')

    if not _success:
      print "The gnue.conf file appears to be missing\n\n" \
           +"The file should be located in one of the following locations\n"
      if os.environ.has_key('INSTALL_PREFIX'):
        print os.environ['INSTALL_PREFIX']+'/etc/gnue.conf'
      if os.environ.has_key('HOME'):
        print os.environ['HOME']+'/.gnue/gnue.conf'
      if os.environ.has_key('INSTALL_PREFIX'):
        print os.environ['INSTALL_PREFIX']+'/etc/gnue.conf.fixed'
      sys.exit("Missing GNUe config file")


  def readConfig(self,location):
    global _OPTION
    self._parser = GConfigParser()

    GDebug.printMesg(1,'Configuration File: "%s"' % location)
    drive = os.path.splitdrive(location)

    fileHandle = openResource(location)

    try:
      self._parser.readfp(fileHandle)
    except DuplicateSectionError:
      raise InvalidFormatError, 'The file has duplicate source definitions.'
    except MissingSectionHeaderError:
      raise InvalidFormatError, 'The file has no source definitions.'
    except:
      print'The file cannot be parsed. %s :: %s' % (sys.exc_type, sys.exc_value)
      raise InvalidFormatError, 'The file cannot be parsed.'

    for option in self._parser.options(self._application):
      _OPTION[option] =  self._parser.get(self._application,option)







