/* $Id: d_mos7.model,v 24.4 2003/04/06 10:36:01 al Exp $ -*- C++ -*-
 * Copyright (C) 2001 Albert Davis
 * Author: Albert Davis <aldavis@ieee.org>
 *
 * This file is part of "Gnucap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *------------------------------------------------------------------
 * Berkeley BSIM3v3.1 model
 * Derived from Spice3f4,Copyright 1990 Regents of the University of California
 * Author: 1991 JianHui Huang and Min-Chie Jeng.
 * Recoded for Gnucap model compiler, Al Davis, 2000
 */
/* This file is automatically generated. DO NOT EDIT */
#ifndef D_MOS7_H_INCLUDED
#define D_MOS7_H_INCLUDED

#include "u_sdp.h"
#include "d_mos_base.h"
/*--------------------------------------------------------------------------*/
class SDP_MOS7
  :public SDP_MOS_BASE{
public:
  explicit SDP_MOS7(const COMMON_COMPONENT*);
public:
  double cdsc;	// Drain/Source and channel coupling capacitance Q/V/m^2
  double cdscb;	// Body-bias dependence of cdsc Q/V/m^2
  double cdscd;	// Drain-bias dependence of cdsc Q/V/m^2
  double cit;	// Interface state capacitance Q/V/m^2
  double nfactor;	// Subthreshold swing Coefficient
  double xj;	// Junction depth in meters
  double vsat;	// Saturation velocity at tnom m/s
  double at;	// Temperature coefficient of vsat m/s
  double a0;	// Non-uniform depletion width effect coefficient.
  double ags;	// Gate bias  coefficient of Abulk.
  double a1;	// Non-saturation effect coefficient
  double a2;	// Non-saturation effect coefficient
  double keta;	// Body-bias coefficient of non-uniform depletion width effect. 1/v
  double nsub;	// Substrate doping concentration 1/cm3
  double npeak;	// Channel doping concentration 1/cm3
  double ngate;	// Poly-gate doping concentration 1/cm3
  double gamma1;	// Vth body coefficient
  double gamma2;	// Vth body coefficient
  double vbx;	// Vth transition body Voltage
  double vbm;	// Maximum body voltage
  double xt;	// Doping depth
  double k1;	// Bulk effect coefficient 1
  double kt1;	// Temperature coefficient of Vth
  double kt1l;	// Temperature coefficient of Vth
  double kt2;	// Body-coefficient of kt1
  double k2;	// Bulk effect coefficient 2
  double k3;	// Narrow width effect coefficient
  double k3b;	// Body effect coefficient of k3
  double w0;	// Narrow width effect parameter
  double nlx;	// Lateral non-uniform doping effect
  double dvt0;	// Short channel effect coeff. 0
  double dvt1;	// Short channel effect coeff. 1
  double dvt2;	// Short channel effect coeff. 2 1/v
  double dvt0w;	// Narrow Width coeff. 0
  double dvt1w;	// Narrow Width effect coeff. 1
  double dvt2w;	// Narrow Width effect coeff. 2
  double drout;	// DIBL coefficient of output resistance
  double dsub;	// DIBL coefficient in the subthreshold region
  double vth0;	// Threshold voltage
  double ua1;	// Temperature coefficient of ua m/v
  double ua;	// Linear gate dependence of mobility m/v
  double ub1;	// Temperature coefficient of ub (m/V)**2
  double ub;	// Quadratic gate dependence of mobility (m/V)**2
  double uc1;	// Temperature coefficient of uc
  double uc;	// Body-bias dependence of mobility
  double u0;	// Low-field mobility at Tnom
  double ute;	// Temperature coefficient of mobility
  double voff;	// Threshold voltage offset
  double delta;	// Effective Vds parameter
  double rdsw;	// Source-drain resistance per width
  double prwg;	// Gate-bias effect on parasitic resistance
  double prwb;	// Body-effect on parasitic resistance
  double prt;	// Temperature coefficient of parasitic resistance
  double eta0;	// Subthreshold region DIBL coefficient
  double etab;	// Subthreshold region DIBL coefficient 1/v
  double pclm;	// Channel length modulation Coefficient
  double pdibl1;	// Drain-induced barrier lowering coefficient
  double pdibl2;	// Drain-induced barrier lowering coefficient
  double pdiblb;	// Body-effect on drain-induced barrier lowering 1/v
  double pscbe1;	// Substrate current body-effect coefficient
  double pscbe2;	// Substrate current body-effect coefficient
  double pvag;	// Gate dependence of output resistance parameter
  double wr;	// Width dependence of rds
  double dwg;	// Width reduction parameter
  double dwb;	// Width reduction parameter
  double b0;	// Abulk narrow width parameter
  double b1;	// Abulk narrow width parameter
  double alpha0;	// substrate current model parameter
  double beta0;	// substrate current model parameter
  double elm;	// Non-quasi-static Elmore Constant Parameter
  double vfbcv;	// Flat Band Voltage parameter for capmod=0 only
  double cgsl;	// New C-V model parameter
  double cgdl;	// New C-V model parameter
  double ckappa;	// New C-V model parameter
  double cf;	// Fringe capacitance parameter
  double clc;	// Vdsat parameter for C-V model
  double cle;	// Vdsat parameter for C-V model
  double dl;	// 
  double dlc;	// 
  double dw;	// 
  double dwc;	// 
  double leff;	// 
  double weff;	// 
  double leffCV;	// 
  double weffCV;	// 
  double abulkCVfactor;	// 
  double cgso;	// 
  double cgdo;	// 
  double cgbo;	// 
  double litl;	// 
};
/*--------------------------------------------------------------------------*/
class TDP_MOS7
  :public TDP_MOS_BASE{
public:
  explicit TDP_MOS7(const DEV_MOS*);
public:
  double temp;	// 
  double tempratio;	// 
  double tempratio_1;	// 
  double vtm;	// vtm
  double ua;	// 
  double ub;	// 
  double uc;	// 
  double u0temp;	// 
  double vsattemp;	// 
  double rds0;	// 
  double phi;	// 
  double sqrtPhi;	// 
  double phis3;	// 
  double Xdep0;	// 
  double vbi;	// 
  double cdep0;	// 
  double k1;	// 
  double k2;	// 
  double vbsc;	// 
  double vth0;	// 
  double vfb;	// 
  double theta0vb0;	// 
  double thetaRout;	// 
};
/*--------------------------------------------------------------------------*/
class MODEL_MOS7
  :public MODEL_MOS_BASE{
public:
  // using generated copy constructor, should be unreachable
  explicit MODEL_MOS7();
  ~MODEL_MOS7() {--_count;}
public: // override virtual
  bool      parse_front(CS&);
  bool      parse_params(CS&);
  void      parse_finish();
  SDP_CARD* new_sdp(const COMMON_COMPONENT* c)const;
  void      print_front(OMSTREAM&)const;
  void      print_params(OMSTREAM&)const;
  void      print_calculated(OMSTREAM&)const;
  bool      is_valid(const COMMON_COMPONENT*)const;
  void      tr_eval(COMPONENT*)const;
public: // not virtual
  static int count() {return _count;}
private: // strictly internal
  enum {LEVEL=7};
  static int _count;
public: // input parameters
  SDP cdsc;	// Drain/Source and channel coupling capacitance Q/V/m^2
  SDP cdscb;	// Body-bias dependence of cdsc Q/V/m^2
  SDP cdscd;	// Drain-bias dependence of cdsc Q/V/m^2
  SDP cit;	// Interface state capacitance Q/V/m^2
  SDP nfactor;	// Subthreshold swing Coefficient
  SDP xj;	// Junction depth in meters
  SDP vsat;	// Saturation velocity at tnom m/s
  SDP at;	// Temperature coefficient of vsat m/s
  SDP a0;	// Non-uniform depletion width effect coefficient.
  SDP ags;	// Gate bias  coefficient of Abulk.
  SDP a1;	// Non-saturation effect coefficient
  SDP a2;	// Non-saturation effect coefficient
  SDP keta;	// Body-bias coefficient of non-uniform depletion width effect. 1/v
  SDP nsub;	// Substrate doping concentration 1/cm3
  SDP npeak;	// Channel doping concentration 1/cm3
  SDP ngate;	// Poly-gate doping concentration 1/cm3
  SDP gamma1;	// Vth body coefficient
  SDP gamma2;	// Vth body coefficient
  SDP vbx;	// Vth transition body Voltage
  SDP vbm;	// Maximum body voltage
  SDP xt;	// Doping depth
  SDP k1;	// Bulk effect coefficient 1
  SDP kt1;	// Temperature coefficient of Vth
  SDP kt1l;	// Temperature coefficient of Vth
  SDP kt2;	// Body-coefficient of kt1
  SDP k2;	// Bulk effect coefficient 2
  SDP k3;	// Narrow width effect coefficient
  SDP k3b;	// Body effect coefficient of k3
  SDP w0;	// Narrow width effect parameter
  SDP nlx;	// Lateral non-uniform doping effect
  SDP dvt0;	// Short channel effect coeff. 0
  SDP dvt1;	// Short channel effect coeff. 1
  SDP dvt2;	// Short channel effect coeff. 2 1/v
  SDP dvt0w;	// Narrow Width coeff. 0
  SDP dvt1w;	// Narrow Width effect coeff. 1
  SDP dvt2w;	// Narrow Width effect coeff. 2
  SDP drout;	// DIBL coefficient of output resistance
  SDP dsub;	// DIBL coefficient in the subthreshold region
  SDP vth0;	// Threshold voltage
  SDP ua1;	// Temperature coefficient of ua m/v
  SDP ua;	// Linear gate dependence of mobility m/v
  SDP ub1;	// Temperature coefficient of ub (m/V)**2
  SDP ub;	// Quadratic gate dependence of mobility (m/V)**2
  SDP uc1;	// Temperature coefficient of uc
  SDP uc;	// Body-bias dependence of mobility
  SDP u0;	// Low-field mobility at Tnom
  SDP ute;	// Temperature coefficient of mobility
  SDP voff;	// Threshold voltage offset
  SDP delta;	// Effective Vds parameter
  SDP rdsw;	// Source-drain resistance per width
  SDP prwg;	// Gate-bias effect on parasitic resistance
  SDP prwb;	// Body-effect on parasitic resistance
  SDP prt;	// Temperature coefficient of parasitic resistance
  SDP eta0;	// Subthreshold region DIBL coefficient
  SDP etab;	// Subthreshold region DIBL coefficient 1/v
  SDP pclm;	// Channel length modulation Coefficient
  SDP pdibl1;	// Drain-induced barrier lowering coefficient
  SDP pdibl2;	// Drain-induced barrier lowering coefficient
  SDP pdiblb;	// Body-effect on drain-induced barrier lowering 1/v
  SDP pscbe1;	// Substrate current body-effect coefficient
  SDP pscbe2;	// Substrate current body-effect coefficient
  SDP pvag;	// Gate dependence of output resistance parameter
  SDP wr;	// Width dependence of rds
  SDP dwg;	// Width reduction parameter
  SDP dwb;	// Width reduction parameter
  SDP b0;	// Abulk narrow width parameter
  SDP b1;	// Abulk narrow width parameter
  SDP alpha0;	// substrate current model parameter
  SDP beta0;	// substrate current model parameter
  SDP elm;	// Non-quasi-static Elmore Constant Parameter
  SDP vfbcv;	// Flat Band Voltage parameter for capmod=0 only
  SDP cgsl;	// New C-V model parameter
  SDP cgdl;	// New C-V model parameter
  SDP ckappa;	// New C-V model parameter
  SDP cf;	// Fringe capacitance parameter
  SDP clc;	// Vdsat parameter for C-V model
  SDP cle;	// Vdsat parameter for C-V model
  int capMod;	// Capacitance model selector (0, 1, 2, other?)
  int nqsMod;	// Non-quasi-static model selector (0, !0)
  int mobMod;	// Mobility model selector (1,2,3,other?)
  int noiMod;	// Noise model selector (not used)
  int paramChk;	// Model parameter checking selector (not used)
  int binUnit;	// Bin unit selector (1, !1)
  double version;	// parameter for model version (not used)
  double tox;	// Gate oxide thickness in meters
  double xpart;	// Channel charge partitioning
  double jctSidewallSatCurDensity;	// Sidewall junction reverse saturation current density
  double mjswg;	// Source/drain (gate side) sw junction capacitance grading coefficient
  double pbswg;	// Source/drain (gate side) sw junction capacitance built in potential
  double unitLengthGateSidewallJctCap;	// Source/drain (gate side) sidewall junction capacitance per unit width
  double jctEmissionCoeff;	// Source/drain junction emission coefficient
  double jctTempExponent;	// Junction current temperature exponent
  double Lint;	// Length reduction parameter
  double Ll;	// Length reduction parameter
  double Lln;	// Length reduction parameter
  double Lw;	// Length reduction parameter
  double Lwn;	// Length reduction parameter
  double Lwl;	// Length reduction parameter
  double Wint;	// Width reduction parameter
  double Wl;	// Width reduction parameter
  double Wln;	// Width reduction parameter
  double Ww;	// Width reduction parameter
  double Wwn;	// Width reduction parameter
  double Wwl;	// Width reduction parameter
  double dwc;	// Delta W for C-V model
  double dlc;	// Delta L for C-V model
  double noia;	// Flicker noise parameter, oxide trap density A
  double noib;	// Flicker noise parameter, oxide trap density B
  double noic;	// Flicker noise parameter, oxide trap density C
  double em;	// Flicker noise parameter V/m
  double ef;	// Flicker noise frequency exponent
public: // calculated parameters
  double cox;	// 
  double factor1;	// 
  double vt_at_tnom;	// 
  double ni;	// 
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
