/* vi:set ts=8 sts=0 sw=8:
 * $Id: srcctrl.h,v 1.2 1999/09/12 14:20:57 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __SRCCTRL_H__
#define __SRCCTRL_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "main.h"
#ifdef USE_SOURCE_CTRL
# include <gtk/gtk.h>

typedef enum scc_type {
	SCC_RCS,		/* RCS */
	SCC_SCCS,		/* SCCS */
	SCC_CCASE,		/* Clear Case */
	SCC_PFORCE,		/* Perforce */
	SCC_PVCS,		/* PVCS */
	SCC_TLIB,		/* TLIB */
	SCC_USER,		/* User defined */
	SCC_NUM_TYPES
} scc_type_t;


typedef enum scc_cmd {
	SCC_CI_LOCK,		/* checkin (locked) */
	SCC_CI_UNLOCK,		/* checkin (unlocked) */
	SCC_CI_INIT,		/* checkin (initial) */
	SCC_CO_UNLOCK,		/* checkout (unlocked) */
	SCC_CO_LOCK,		/* checkout (locked) */
	SCC_CO_UNDO,		/* undo checkout */
	SCC_REVHIST,		/* revision history */
	SCC_NUM_CMDS
} scc_cmd_t;


/*** global variables ***/
extern char *scc_cmd_desc[SCC_NUM_CMDS];


# if defined(GTK_HAVE_FEATURES_1_1_0) && !defined(USE_GNOME)
extern void scc_menu_cb(GtkWidget *wgt, gpointer cbdata, guint cbaction);
# endif

# if defined(USE_GNOME) || !defined(GTK_HAVE_FEATURES_1_1_0)
extern void scc_checkin_locked(GtkWidget *widget, gpointer cbdata);
extern void scc_checkin_unlocked(GtkWidget *widget, gpointer cbdata);
extern void scc_checkin_initial(GtkWidget *widget, gpointer cbdata);
extern void scc_checkout_unlocked(GtkWidget *widget, gpointer cbdata);
extern void scc_checkout_locked(GtkWidget *widget, gpointer cbdata);
extern void scc_checkout_undo(GtkWidget *widget, gpointer cbdata);
extern void scc_rev_history(GtkWidget *widget, gpointer cbdata);
# endif	/* defined(USE_GNOME) || !defined(GTK_HAVE_FEATURES_1_1_0) */

#endif	/* USE_SOURCE_CTRL */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __SRCCTRL_H__ */
