#ifndef PLAYLIST_H
#define PLAYLIST_H
#include "mp3list.h"

extern GList *playlist;

void playlist_set_other_row_colours(MP3 *mp3);
int playlist_add_song(MP3 *mp3);
void playlist_remove_row(MP3 *mp3);
void playlist_delete(gpointer data);
void playlist_save(char *directory, char *filename);
void playlist_load(char *directory, char *filename);
void playlist_add_row(MP3 *mp3);
void playlist_add(GtkWidget *w, gpointer data);
void playlist_add_album(GtkWidget *w, gpointer data);
int playlist_cmp_func(GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2);
void playlist_sort_button_toggled(GtkWidget *w);
void playlist_mark_row_played(GtkWidget *w, gpointer data);
void playlist_mark_row_unplayed(GtkWidget *w, gpointer data);
void playlist_update_row_display(int row_num);
void playlist_update_display();
void playlist_set_all_unplayed();
void playlist_move_row_up(GtkWidget *w, gpointer data);
void playlist_move_row_down(GtkWidget *w, gpointer data);
void playlist_keypress(GtkWidget *w, GdkEventKey *event);
void playlist_clear_rules();

/* from playlist_managment.c */
void playlist_scan();
void playlist_combo_activated(GtkWidget *w, gpointer data);
void playlist_new_cb(GtkWidget *w, gpointer data);
void playlist_save_dialog_done(GtkWidget *w, gpointer data);
void playlist_save_cb(GtkWidget *w, gpointer data);
void playlist_save_as_cb(GtkWidget *w, gpointer data);

#define PLAYLIST_POS_COL 3

#endif
