// -*- c++ -*-

//  Gnomoradio - wraporadio/wraporadio.h
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __WRAPORADIO_WRAPORADIO_H
#define __WRAPORADIO_WRAPORADIO_H

#include <libintl.h>
#include <sstream>
#include <cstdlib>
#include "roboradio/init.h"
#include "roboradio/song.h"
#include "roboradio/song-list-library.h"
#include "roboradio/song-list-search.h"
#include "roboradio/song-list-cache.h"
#include "roboradio/song-list-history.h"
#include "roboradio/song-list-radio.h"
#include "roboradio/xspf.h"

// gettext stuff
#define _(String) gettext  (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

namespace Wraporadio
{
	using Roboradio::ref_ptr;

	class Init : public Roboradio::Init
	{
	};

	class Player
	{
	};

	typedef Roboradio::State& State;
	typedef Roboradio::Time Time;

#if 0
	class Song : public sigc::trackable
	{
	protected:
		Roboradio::SongRef s;

	public:
		//void set_info (const std::string &key, const Glib::ustring &value) { 
		//Glib::ustring get_info (const std::string &key) const { 
		void get_info (std::vector<std::string> &keys, std::vector<Glib::ustring> &values) const;

		int get_rating () const { return s->get_rating(); }
		void set_rating (int new_rating) { return s->set_rating(); }
		void thumbs_up () { s->thumbs_up(); }
		void thumbs_down () { s->thumbs_down(); }

		SongStatus get_status () const { return s->get_status(); }
		Time get_length () const { return s->get_length(); }
		Glib::ustring get_url () const { return s->get_url(); }
	};
#else
	typedef Roboradio::SongRef Song;
#endif

	class SongList : public sigc::trackable
	{
	public:
		enum SongListType
		{
			STANDARD,
			LIBRARY,
			CACHE,
			SEARCH,
			HISTORY,
			RADIO
		};

//	protected:
		ref_ptr<Roboradio::SongList> sl;
		SongList (ref_ptr<Roboradio::SongList> songlist) : sl(songlist) { }
	public:
		SongList (const Glib::ustring &name)
			: sl(ref_ptr<Roboradio::SongList>(new Roboradio::SongListMutable(name))) { }
		SongList ()
			: sl(ref_ptr<Roboradio::SongList>()) { }

		typedef Roboradio::SongList::iterator iterator;

		bool destroyable () { return sl->destroyable(); }
		void destroy () { sl->destroy(); }

		iterator get_current_song () const { return sl->get_current_song(); }

		const Glib::ustring get_name () const { return sl->get_name(); }
		void set_name (const Glib::ustring &n) { sl->set_name(n); }
		
		SongListType get_type () const
		{
			if (dynamic_cast<Roboradio::SongListHistory*>(&*sl))
				return HISTORY;
			if (dynamic_cast<Roboradio::SongListLibrary*>(&*sl))
				return LIBRARY;
			if (dynamic_cast<Roboradio::SongListRadio*>(&*sl))
				return RADIO;
			if (dynamic_cast<Roboradio::SongListCache*>(&*sl))
				return CACHE;
			if (dynamic_cast<Roboradio::SongListSearch*>(&*sl))
				return SEARCH;
			return STANDARD;
		}

		iterator begin () { return sl->begin(); }
		iterator end () { return sl->end(); }

		void set_repeat (bool r) { sl->set_repeat(r); }
		bool get_repeat () const { return sl->get_repeat(); }
		bool get_repeatable () const { return sl->get_repeatable(); }
		void set_shuffle (bool s) { sl->set_shuffle(s); }
		bool get_shuffle () const { return sl->get_shuffle(); }
		bool get_shufflable () const { return sl->get_shufflable(); }
		SongList get_shuffle_list () const { return SongList(sl->get_shuffle_list()); }

		bool get_mutable () const { return sl->get_mutable() ? true : false; }

		bool exists () const { return &*sl; }

		static std::vector<SongList> get_named_song_lists () {
			std::vector<ref_ptr<Roboradio::SongList> > v(Roboradio::SongList::get_named_song_lists());
			std::vector<ref_ptr<Roboradio::SongList> >::const_iterator i;
			std::vector<SongList> retval;
			for (i = v.begin(); i != v.end(); ++i)
				retval.push_back(SongList(*i));
			return retval;
		}

		bool operator== (const SongList &list) const { return &*sl == &*list.sl; }
		bool operator!= (const SongList &list) const { return &*sl != &*list.sl; }
		bool operator< (const SongList &list) const { return &*sl < &*list.sl; }

		iterator insert (iterator pos, const Song &value)
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->insert(pos, value); }
		void move (iterator old_pos, iterator new_pos)
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->move(old_pos, new_pos); }
		iterator remove (iterator pos)
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->remove(pos); }
		void pop_front ()
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->pop_front(); }
		void pop_back ()
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->pop_back(); }
		void push_front (const Song &value)
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->push_front(value); }
		void push_back (const Song &value)
			{ Roboradio::SongListMutable *p = sl->get_mutable(); if (p) p->push_back(value); }

		sigc::signal<void,bool> &signal_shuffle_changed () { return sl->signal_shuffle_changed; }
		sigc::signal<void,bool> &signal_repeat_changed () { return sl->signal_repeat_changed; }
		sigc::signal<void,Glib::ustring> &signal_name_changed () { return sl->signal_name_changed; }

		sigc::signal<void,iterator> &signal_removed () { return sl->signal_removed; }
		sigc::signal<void,iterator> &signal_inserted () { return sl->signal_inserted; }
		sigc::signal<void,iterator> &signal_moved () { return sl->signal_moved; }
		sigc::signal<void,iterator> &signal_song_info_changed () { return sl->signal_song_info_changed; }
		sigc::signal<void,iterator,unsigned int> &signal_song_import_progress () { return sl->signal_song_import_progress; }
		sigc::signal<void> &signal_destroyed () { return sl->signal_destroyed; }
		sigc::signal<void> &signal_current_song_changed () { return sl->signal_current_song_changed; }

		static sigc::signal<void,ref_ptr<Roboradio::SongList> > &signal_new_named_song_list () { return Roboradio::SongList::signal_new_named_song_list; } // FIXME: *** remove roboradio reference
		static sigc::signal<void,ref_ptr<Roboradio::SongList> > &signal_named_song_list_destroyed () { return Roboradio::SongList::signal_named_song_list_destroyed; }
		static sigc::signal<void,ref_ptr<Roboradio::SongList> > &signal_global_name_changed () { return Roboradio::SongList::signal_global_name_changed; }
	};

	class SongListSearch : public SongList
	{
	public:
		SongListSearch (const Glib::ustring &criteria,
				const Glib::ustring &name = Glib::ustring())
			: SongList(ref_ptr<Roboradio::SongList>(new Roboradio::SongListSearch(criteria, name))) { }

		void set_criteria (const Glib::ustring &criteria) { static_cast<Roboradio::SongListSearch*>(&*sl)->set_criteria(criteria); }
		Glib::ustring get_criteria () const { return static_cast<Roboradio::SongListSearch*>(&*sl)->get_criteria(); }

		void search_online (const Glib::ustring &search_string) { static_cast<Roboradio::SongListSearch*>(&*sl)->search_online(search_string); }
	};

	class SongListRadio : public SongList
	{
	public:
		SongListRadio (const Glib::ustring &name,
			       unsigned short percent_recommend)
			: SongList(ref_ptr<Roboradio::SongList>(new Roboradio::SongListRadio(Roboradio::Init::get_state().library(), name, percent_recommend))) { }

		unsigned short get_percent_recommend () const { return static_cast<Roboradio::SongListRadio*>(&*sl)->get_percent_recommend(); }
		void set_percent_recommend (unsigned short pr) { static_cast<Roboradio::SongListRadio*>(&*sl)->set_percent_recommend(pr); }
	};

	class SongListHistory : public SongList
	{
	public:
		unsigned int get_number () const { return std::atoi(static_cast<Roboradio::SongListHistory*>(&*sl)->get_number().c_str()); }
		void set_number (unsigned int days) { std::ostringstream stm; stm << days; static_cast<Roboradio::SongListHistory*>(&*sl)->set_number(stm.str()); }
	};

	namespace XSPF
	{
		static inline void import_list (const Glib::ustring &url) { Roboradio::XSPF::import_list(url); }
		static inline void export_list (const Glib::ustring &filename) { Roboradio::XSPF::export_list(filename); }
	}
};

#endif
