// -*- c++ -*-

//  Gnomoradio - roboradio/song-list-search.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SONG_LIST_SEARCH_H
#define __ROBORADIO_SONG_LIST_SEARCH_H

#include <string>
#include "rainbow/http-client.h"
#include "roboradio/song-list.h"

namespace Roboradio
{
	class Criteria;

	class SongListSearch : public SongList
	{
	public:
		SongListSearch (const Glib::ustring &criteria,
				const Glib::ustring &name = Glib::ustring());
		virtual ~SongListSearch ();

		void set_criteria (const Glib::ustring &criteria);
		Glib::ustring get_criteria () const;

		void search_online (const Glib::ustring &search_string);

	protected:
		void on_song_changed (SongRef song);
		void on_online_search_done (bool success);

		Criteria *criteria;
		Glib::ustring crit;
		bool online;

		Rainbow::HttpClient *http;
	};
}

#endif
