/*  GnomeKiss - A KiSS viewer for the GNOME desktop
    Copyright (C) 2000-2001  Nick Lamb <njl195@zepler.org.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "kiss.h"

/* Implementation */
GtkWidget *app, *area, *appbar, *pref_dialog, *error_clist;
GtkWidget *about, *error_list, *set_open, *config_open, *add_open;
GtkWidget *buttons[SETS], *items[SETS];

static GtkTargetEntry targets[1]= { { "text/uri-list", 0, 1} };

static void set_toggle(char *toggle, gboolean value) {
  GtkWidget *widget;

  widget = get_widget(pref_dialog, toggle);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), value);
}

static void preferences(void) {
  GtkWidget *widget;

  gnome_config_push_prefix("/GnomeKiss/");
  prefs.midi= gnome_config_get_bool("Sound/midi=true");
  set_toggle("pref_midi", prefs.midi);

  prefs.midi_player= gnome_config_get_string("Sound/midi_player=playmidi");
  widget = get_widget(pref_dialog, "pref_midi_player");
  gtk_entry_set_text(GTK_ENTRY(widget), prefs.midi_player);

  prefs.esound= gnome_config_get_bool("Sound/esound=true");
  set_toggle("pref_esound", prefs.esound);

  prefs.error_list= gnome_config_get_bool("Diagnostics/error_list=true");
  set_toggle("pref_error_list", prefs.error_list);
  prefs.warnings= gnome_config_get_bool("Diagnostics/warnings=true");
  set_toggle("pref_warnings", prefs.warnings);
  prefs.trace= gnome_config_get_bool("Diagnostics/trace=false");
  set_toggle("pref_trace", prefs.trace);

  prefs.ignore_colon= gnome_config_get_bool("Features/ignore_colon=false");
  set_toggle("pref_ignore_colon", prefs.ignore_colon);
  prefs.fkiss_case= gnome_config_get_bool("Features/fkiss_case=false");
  set_toggle("pref_fkiss_case", prefs.fkiss_case);
  prefs.default_palette= gnome_config_get_bool("Features/default_palette=false");
  set_toggle("pref_default_palette", prefs.default_palette);
  
  prefs.speed_factor= gnome_config_get_int("Features/speed_factor=1");
  widget = get_widget(pref_dialog, "pref_speed_factor");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),(gfloat)prefs.speed_factor);

  prefs.min_timer= gnome_config_get_int("Features/min_timer=1");
  widget = get_widget(pref_dialog, "pref_min_timer");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),(gfloat)prefs.min_timer);

  prefs.catch_drop= gnome_config_get_bool("Features/catch_drop=false");
  set_toggle("pref_catch_drop", prefs.catch_drop);
}

int
main (int argc, char *argv[])
{
  GtkWidget *application;
  int i;
  guchar widget_name[]= "show_setN";

  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  gnome_init ("gnomekiss", VERSION, argc, argv);

  gtk_widget_push_visual(gdk_rgb_get_visual());
  gtk_widget_push_colormap(gdk_rgb_get_cmap());
  application = create_application ();
  about= create_about ();
  error_list= create_error_list ();
  set_open= create_set_open ();
  config_open= create_config_open ();
  add_open= create_add_open ();
  pref_dialog= create_preferences ();
  gtk_widget_pop_visual();
  gtk_widget_pop_colormap();

  /* Get initial prefs state */
  preferences();

  app = application;
  area = get_widget(app, "area");
  appbar = get_widget(app, "appbar");
  error_clist = get_widget(error_list, "error_clist");

  for (i= 0; i < SETS; ++i) {
    snprintf(widget_name, sizeof(widget_name), "show_set%d", i);
    buttons[i]= get_widget(app, widget_name);

    snprintf(widget_name, sizeof(widget_name), "set_%d", i);
    items[i]= get_widget(app, widget_name);
  }

  gtk_drag_dest_set(app, GTK_DEST_DEFAULT_ALL, targets, 1, GDK_ACTION_COPY);

  gtk_widget_show (app);

  if (argc > 1) {
    open_either(argv[1]);
  }

  gtk_main ();
  return 0;
}

