/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
using System;
using Gtk;
using System.Threading;
using System.Diagnostics;
using System.IO;
using Mono.Posix;
using System.Collections;
using GLib;

namespace GnomeRDP 
{
	public class ProcessCaller
	{
		private string					_fileName;
		private string					_arguments;
		private string					_workingDirectory;
		private bool					_vnc;
		private string					_passwd;
		private Gtk.Window				_wnd;
		private static int 			_connectionCount = 0;
		private static ArrayList 		_processes = new ArrayList();
		private System.Threading.Thread _thr;
		
		public static int ConnectionCount
		{
			get {return _connectionCount;}
		}
		public static ArrayList Processes
		{
			get {return _processes;}
		}
		
		public ProcessCaller(
			string		fileName,
			string 	arguments,
			string 	workingDirectory,
			bool   		vnc,
			string 	passwd,
			Gtk.Window 	pwnd)	
		{
			this._fileName = fileName;
			this._arguments = arguments;
			this._workingDirectory = workingDirectory;
			this._vnc = vnc;
			this._passwd = passwd;
			this._wnd = pwnd;
			_processes.Add(new Process());
			((Process)_processes[_processes.Count-1]).StartInfo.UseShellExecute 		= false;
			((Process)_processes[_processes.Count-1]).StartInfo.RedirectStandardOutput	= true;
			((Process)_processes[_processes.Count-1]).StartInfo.RedirectStandardError	= true;
			((Process)_processes[_processes.Count-1]).StartInfo.RedirectStandardInput	= true;
			((Process)_processes[_processes.Count-1]).StartInfo.CreateNoWindow 			= true;
			((Process)_processes[_processes.Count-1]).StartInfo.FileName	 			= this._fileName;
			((Process)_processes[_processes.Count-1]).StartInfo.Arguments 			 	= this._arguments;
			((Process)_processes[_processes.Count-1]).StartInfo.WorkingDirectory	 	= this._workingDirectory;
			((Process)_processes[_processes.Count-1]).EnableRaisingEvents 			 	= true;
			((Process)_processes[_processes.Count-1]).WaitForInputIdle();			
		}
		
		public void StartProcess()
		{
			this._thr = new System.Threading.Thread(new ThreadStart(ThreadRoutine));
			this._thr.Start();
		}
		
		private void ThreadRoutine()
		{
			_connectionCount++;
			((Process)_processes[_processes.Count-1]).Start();
			System.Threading.Thread threadReadStdOut = new System.Threading.Thread(new ThreadStart(ReadStdOut));
			threadReadStdOut.Start();
			System.Threading.Thread threadReadStdErr = new System.Threading.Thread(new ThreadStart(ReadStdErr));
			threadReadStdErr.Start();
			if (this._vnc)
			{
				try
				{
					((Process)_processes[_processes.Count-1]).StandardInput.WriteLine(this._passwd);

				}
				catch (Exception e)
				{
					Console.WriteLine(e.Message);
				}
			}
			((Process)_processes[_processes.Count-1]).WaitForExit();
			_connectionCount--;
		}	
		
		public virtual void ReadStdOut()
		{
			string msg = GLib.Markup.EscapeText(((Process)_processes[_processes.Count-1]).StandardOutput.ReadToEnd());
			if (msg != null)
			{
				if (msg.Trim().Length > 0)
				{
					Gdk.Threads.Enter();
					MessageDialog md = new MessageDialog(this._wnd, DialogFlags.Modal, MessageType.Info, ButtonsType.Close, msg);
					md.Run();
					md.Destroy();
					Gdk.Threads.Leave();
				}
			}										
		}
		
		public virtual void ReadStdErr()
		{
			string msg = GLib.Markup.EscapeText(((Process)_processes[_processes.Count-1]).StandardError.ReadToEnd());
			if (msg != null)
			{
				if (msg.Trim().Length > 0)
				{
					Gdk.Threads.Enter();
					MessageDialog md = new MessageDialog(this._wnd, DialogFlags.Modal, MessageType.Info, ButtonsType.Close, msg);
					md.Run();
					md.Destroy();
					Gdk.Threads.Leave();
				}
			}													
		}		
	}
}
