#include <config.h>
#include "gnome-cmd-includes.h"


static GnomeCmdDir *
get_active_dir (GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (mw);
	return gnome_cmd_file_selector_get_directory (fs);
}


/*
static gchar*
get_active_dir_path (GnomeCmdMainWin *mw)
{
	GnomeCmdDir *dir = get_active_dir (mw);
	return gnome_cmd_dir_get_path (dir);
}
*/

/**
 * The list returned from this function is a copy and must be freed. This files must not
 * be unrefed though
 */
static GList *
get_selected_files (GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (mw);
	return gnome_cmd_file_selector_get_selected_files (fs);
}


/**
 * The file returned from this function is not to be unrefed
 */
static GnomeCmdFile *
get_selected_file (GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (mw);
	return gnome_cmd_file_selector_get_selected_file (fs);
}


/*
static GList *
get_selected_filenames (GnomeCmdMainWin *mw)
{
	GList *files = get_selected_files (mw);
	GList *filenames = NULL;

	while (files)
	{
		GnomeCmdFile *finfo = GNOME_CMD_FILE (files->data);
		filenames = g_list_append (filenames, g_strdup (finfo->info->name));
		files = files->next;
	}

	return filenames;
}
*/

/************** File Menu **************/
void
file_cap_cut                        (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GList *files = get_selected_files (mw);

	if (files) {
		cap_cut_files (files, get_active_dir (mw));
		g_list_free (files);
	}
}


void
file_cap_copy                       (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GList *files = get_selected_files (mw);
	
	if (files) {
		cap_copy_files (files, get_active_dir (mw));
		g_list_free (files);
	}
}


void
file_cap_paste                      (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	cap_paste_files (get_active_dir (mw));
}


void
file_copy                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *src_fs, *dest_fs;

	if (mw) {
		src_fs = gnome_cmd_main_win_get_active_fs (mw);
		dest_fs = gnome_cmd_main_win_get_inactive_fs (mw);
		
		if (src_fs && dest_fs)
			gnome_cmd_prepare_copy_dialog_show (
				src_fs, dest_fs);
	}
}


void
file_move                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *src_fs, *dest_fs;

	if (mw) {
		src_fs = gnome_cmd_main_win_get_active_fs (mw);
		dest_fs = gnome_cmd_main_win_get_inactive_fs (mw);
		
		if (src_fs && dest_fs)
			gnome_cmd_prepare_move_dialog_show (
				src_fs, dest_fs);
	}
}


void
file_delete                         (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	if (mw) {
		GList *files = get_selected_files (mw);

		if (files) {
			gnome_cmd_file_delete (files);
			g_list_free (files);
		}
	}
}


void
file_view                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFile *finfo = get_selected_file (mw);

	if (finfo)
		gnome_cmd_file_view (finfo);
}


void
file_edit                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFile *finfo = get_selected_file (mw);

	if (finfo)
		gnome_cmd_file_edit (finfo);
}


void
file_chmod                          (GtkMenuItem     *menuitem,
									 GnomeCmdMainWin *mw)
{
	GList *files = get_selected_files (mw);

	if (files) {
		gnome_cmd_file_show_chmod_dialog (files);
		g_list_free (files);
	}
}


void
file_chown                          (GtkMenuItem     *menuitem,
								     GnomeCmdMainWin *mw)
{
	GList *files = get_selected_files (mw);

	if (files) {
		gnome_cmd_file_show_chown_dialog (files);
		g_list_free (files);
	}
}


void
file_mkdir                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GtkWidget *dialog;
	GnomeCmdDir *dir;

	dir = gnome_cmd_file_selector_get_directory (
		gnome_cmd_main_win_get_active_fs (mw));
	
	dialog = gnome_cmd_mkdir_dialog_new (dir);

	gtk_widget_ref (dialog);
	gtk_object_set_data_full (GTK_OBJECT (mw), "gnome_cmd_mkdir_dialog", dialog,
							  (GtkDestroyNotify)gtk_widget_unref);
	gtk_widget_show (dialog);
}


void
file_properties                     (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFile *finfo = get_selected_file (mw);

	if (finfo)
		gnome_cmd_file_show_properties (finfo);
}


void
file_diff                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdFile *finfo = get_selected_file (mw);

	if (finfo)
	{
		GList *tmp;
		GList *all_files = gnome_cmd_file_selector_get_all_files (
			gnome_cmd_main_win_get_inactive_fs (mw));
		tmp = all_files;

		/**
		 * Go through all the files in the other list until we find one with the same name
		 */
		while (tmp)
		{
			GnomeCmdFile *finfo2 = (GnomeCmdFile*)tmp->data;

			if (strcmp (gnome_cmd_file_get_name (finfo),
						gnome_cmd_file_get_name (finfo2)) == 0)
			{
				gchar *cmd = g_strdup_printf (gnome_cmd_data_get_differ (),
											  gnome_cmd_file_get_path (finfo),
											  gnome_cmd_file_get_path (finfo2));

				run_command (cmd);
				g_print (_("running \"%s\"\n"), cmd);
				g_free (cmd);
			}
			tmp = tmp->next;
		}
	}
}


void
file_exit                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	gtk_main_quit ();
}


/************** Mark Menu **************/
void
mark_toggle                         (GtkMenuItem     *menuitem,
									GnomeCmdMainWin *mw)
{
	gnome_cmd_file_selector_toggle (
		gnome_cmd_main_win_get_active_fs (mw));
}


void
mark_toggle_and_step                (GtkMenuItem     *menuitem,
									GnomeCmdMainWin *mw)
{
	gnome_cmd_file_selector_toggle_and_step (
		gnome_cmd_main_win_get_active_fs (mw));	
}


void
mark_select_all                     (GtkMenuItem     *menuitem,
									 GnomeCmdMainWin *mw)
{
	gnome_cmd_file_selector_select_all (
		gnome_cmd_main_win_get_active_fs (mw));
}


void
mark_unselect_all                   (GtkMenuItem     *menuitem,
  								     GnomeCmdMainWin *mw)
{
	gnome_cmd_file_selector_unselect_all (
		gnome_cmd_main_win_get_active_fs (mw));
}


/************** Edit Menu **************/
void
edit_search                         (GtkMenuItem     *menuitem,
 								     GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (mw);
	GnomeCmdConnection *con = gnome_cmd_file_selector_get_connection (fs);
	GtkWidget *dialog =
		gnome_cmd_search_dialog_new (
			gnome_cmd_connection_get_baseuri (con),
			gnome_cmd_file_selector_get_directory (fs));
	
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_search_dialog", dialog,
				(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
}


/************** View Menu **************/

void
view_refresh                           (GtkMenuItem     *menuitem,
 							            GnomeCmdMainWin *mw)
{
	GnomeCmdFileSelector *fs = gnome_cmd_main_win_get_active_fs (mw);
	gnome_cmd_file_selector_reload (fs);
}


/************** Options Menu **************/
void
options_edit                        (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GtkWidget *dialog = gnome_cmd_options_dialog_new (mw);
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_options_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (mw));
	gtk_widget_show (dialog);
}


void
options_save                        (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	gnome_cmd_data_save ();
}


void
options_save_position               (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	gnome_cmd_data_save_position ();
}



/************** FTP Menu **************/
void
ftp_connect                         (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GtkWidget *dialog = gnome_cmd_ftp_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_ftp_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
}


void
ftp_disconnect                      (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	GnomeCmdConnection *con = gnome_cmd_file_selector_get_connection (
		gnome_cmd_main_win_get_active_fs (mw));

	if (con->type == CON_TYPE_FTP)
	{
		gnome_cmd_file_selector_set_connection (
			gnome_cmd_main_win_get_active_fs (mw),
			gnome_cmd_connection_get_local ());

		gnome_cmd_file_selector_set_connection (
			gnome_cmd_main_win_get_inactive_fs (mw),
			gnome_cmd_connection_get_local ());
		
		gnome_cmd_connection_free (con);
	}
}


void
ftp_options                         (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	/*
	GtkWidget *dialog = gnome_cmd_options_dialog_new (mw);
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_options_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gnome_cmd_options_dialog_set_tab (GNOME_CMD_OPTIONS_DIALOG (dialog),
									  GNOME_CMD_OPTIONS_DIALOG_TAB_FTP);
	gtk_widget_show (dialog);
	*/
}



void
cvs_import                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{/*
	GtkWidget *dialog = gnome_cmd_cvs_import_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_cvs_import_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
	*/	
}


void
cvs_checkout                        (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{/*
	GtkWidget *dialog = gnome_cmd_cvs_checkout_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (GTK_OBJECT (mw), "gnome_cmd_cvs_checkout_dialog", dialog,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
	*/
	
}


void
cvs_login                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	//cvs_session_login ();
}


void
cvs_logout                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	//cvs_session_logout ();
}


void
cvs_update                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	/*
	GtkWidget *dialog = gnome_cmd_cvs_update_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_cvs_update_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);

	cvs_session_setdir (get_active_dir_path (mw));
	
	cvs_session_update (get_selected_filenames (mw),
						(CvsOutputCallback)gnome_cmd_cvs_update_dialog_parse,
						dialog);
						*/
}


void
cvs_commit                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
//	GtkWidget *dialog = gnome_cmd_cvs_commit_dialog_new ();
//	gtk_widget_show (dialog);
	//cvs_session_commit (get_selected_filenames (mw), "Lots of things", NULL, NULL);
}


void
cvs_add                             (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	//cvs_session_add (get_selected_filenames (mw));
}


void
cvs_remove                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	//cvs_session_remove (get_selected_filenames (mw));
}


void
cvs_log                             (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{/*
	GtkWidget *dialog;
	GnomeCmdFile *file;
	
	dialog = gnome_cmd_cvs_log_dialog_new ();
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_cvs_log_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog);
	
	file = gnome_cmd_file_selector_get_selected_file (
		gnome_cmd_main_win_get_active_fs (mw));

	if (file)
	{
		gnome_cmd_cvs_log_dialog_log_file (
			GNOME_CMD_CVS_LOG_DIALOG (dialog),
			gnome_cmd_dir_get_path (
				gnome_cmd_file_selector_get_directory (gnome_cmd_main_win_get_active_fs (mw))),
			file->info->name);
	}
	*/
	//cvs_session_log ("a-file.ext", NULL, NULL);
}


void
cvs_diff                            (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{/*
	gchar *cmd;
	GnomeCmdDir *dir;
	GnomeCmdFile *file;
	
	file = gnome_cmd_file_selector_get_selected_file (
		gnome_cmd_main_win_get_active_fs (mw));

	dir = gnome_cmd_file_selector_get_directory (gnome_cmd_main_win_get_active_fs (mw));
	chdir (gnome_cmd_dir_get_path (dir));
	cmd = g_strdup_printf (gnome_cmd_data_get_cvs_differ(), file->info->name);
	run_command (cmd);
	g_free (cmd);
	*/
	//cvs_session_diff ("a-file.ext", NULL, NULL);
}


void
cvs_options                         (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	/*
	GtkWidget *dialog = gnome_cmd_options_dialog_new (mw);
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "gnome_cmd_options_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);
	gnome_cmd_options_dialog_set_tab (GNOME_CMD_OPTIONS_DIALOG (dialog),
									  GNOME_CMD_OPTIONS_DIALOG_TAB_CVS);
	gtk_widget_show (dialog);
	*/
}




/************** Help Menu **************/

void
help_help                           (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	gnome_app_message (GNOME_APP (mw), "Please implement me!");
}


void
help_about                          (GtkMenuItem     *menuitem,
                                     GnomeCmdMainWin *mw)
{
	gchar *authors[] = {
		"Marcus Bjurman (marbj499@student.liu.se)",
		NULL
	};

	GtkWidget *dialog = gnome_about_new (
		"Gnome Commander",
		VERSION,
		"Copyright: Marcus Bjurman 2001-2002",
		(const gchar**)authors,
		"This is a GPL licenced program",
		NULL);

	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_widget_ref (dialog);
	gtk_object_set_data_full (
		GTK_OBJECT (mw), "about_dialog", dialog,
		(GtkDestroyNotify) gtk_widget_unref);

	gtk_widget_show (dialog);
}
