/******************************************************************************\
 gnofin/xml-io.h   $Revision: 1.8 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef XML_IO_H
#define XML_IO_H

#include <gtk/gtkwindow.h>
#include <gnome-xml/tree.h>
#include "data-types.h"


/******************************************************************************
 * Basic file i/o
 */

gboolean xml_io_probe (const gchar *filename);
gboolean xml_io_load  (GtkWindow *, const gchar * fname, Bankbook *);
gboolean xml_io_save  (GtkWindow *, const gchar * fname, const Bankbook *);

void xml_io_set_compression_level (gint level);   // 0-9
gint xml_io_get_compression_level (void);


/******************************************************************************
 * XML clips for streaming portions of the data structure
 *
 *  - for storage in clipboard (allows external apps to get at the data)
 *  - implemented using xmlDocDumpMemory/xmlParseMemory
 */

/* these functions read/write a bankbook from/to an XML data stream.
 * the root tag is named gnofin_clip, and is not intended to be
 * saved to disk, but rather is ideal for transfering bankbook data
 * in and out of a clipboard and across applications. 
 *
 * the data parameter must be free'd by the caller. */

gboolean xml_io_clip_probe (gchar *data, guint size);
gboolean xml_io_clip_read  (gchar *data, guint size, Bankbook *book);
gboolean xml_io_clip_write (gchar **data, guint *size, const Bankbook *book);


/******************************************************************************
 * Extensions
 *
 * A module should allocate and fill out its own XmlIOExtension structure,
 * and then pass that structure to the xml_io_extension_register function.
 *
 *     read (win, root_node, private_data);
 *     write (win, parent_node, private_data); 
 */

typedef struct _XmlIOExtension XmlIOExtension;
typedef gboolean   (* XmlIOExtensionReadFunc) (GtkWindow *, xmlNodePtr, gpointer);
typedef xmlNodePtr (* XmlIOExtensionWriteFunc) (GtkWindow *, xmlDocPtr, xmlNsPtr, gpointer);

struct _XmlIOExtension
{
  const gchar *name;      /* must be a unique extension name, used as the XML tag */

  XmlIOExtensionReadFunc  read;
  XmlIOExtensionWriteFunc write;

  gpointer private_data;  /* optionally filled in by the extension writer */
};

gboolean xml_io_extension_register   (XmlIOExtension *);
void     xml_io_extension_unregister (XmlIOExtension *);

#endif
