/******************************************************************************\
 gnofin/ui.h   $Revision: 1.14.2.1 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef UI_H
#define UI_H

#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-appbar.h>
#include <gtk/gtknotebook.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkbox.h>
#include "ui-types.h"
#include "data-types.h"

GNOFIN_API_BEGIN

struct _UI
{
  /* private */

  Bankbook        *book;      		/* current bankbook */

  GnomeApp        *app;
  GtkNotebook     *notebook;  		/* contains record list objects */
  GtkMenu         *notebook_menu;
  guint            switch_page_id;
  GtkBox          *vbox;      		/* contains the list stacked above the editor */ 

  UI_RecordList   *current_list; 	/* currently selected list */
  UI_RecordEditor *editor;   		/* record editor */
  UI_Menubar      *menubar;
  UI_Toolbar      *toolbar;
  UI_Statusbar    *statusbar;

  gchar           *filename;
};

UI      *ui_create (void);
gboolean ui_exit   (UI *);  // tries to destroy the UI

gboolean ui_close         (UI *);  // tries to close whatever file is open
gboolean ui_save_file     (UI *, const gchar *filename);
gboolean ui_load_file_1   (UI *, gchar **filename, Bankbook **book);
gboolean ui_load_file     (UI *, const gchar *filename);
gboolean ui_load_bankbook (UI *, Bankbook *book, const gchar *filename);
gboolean ui_merge_account (UI *, const Account *account, gboolean as_new_account);
gboolean ui_is_empty      (UI *);

void ui_remove_current_record        (UI *);
void ui_toggle_current_record_status (UI *);
void ui_remove_current_account       (UI *);
void ui_modify_current_account       (UI *);
void ui_modify_current_record_types  (UI *);

#ifdef ENABLE_UI_RECORD_SELECT
void ui_select_records_current_account (UI *);
#endif

void ui_select_record                (UI *, Record *);
void ui_insert_account               (UI *);

Account *ui_get_current_account (UI *);
Record  *ui_get_current_record  (UI *);

GnomeAppBar *ui_get_appbar (UI *);

/* Inline helper functions */
static inline const gchar *
  ui_get_current_filename (UI *ui) { return ui->filename; } 
static inline Bankbook *
  ui_get_current_bankbook (UI *ui) { return ui->book; }
static inline GtkWindow *
  ui_get_window (UI *ui) { return GTK_WINDOW (ui->app); }
static inline UI_Menubar *
  ui_get_menubar (UI *ui) { return ui->menubar; }

GNOFIN_API_END

#endif

// vim: ts=8 sw=2
