/******************************************************************************\
 gnofin/file-filter.h   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FILE_FILTER_H
#define FILE_FILTER_H

#include <gtk/gtkwindow.h>
#include "data-types.h"

GNOFIN_API_BEGIN

typedef struct _FileFilter FileFilter;

typedef gboolean (* FileImportFunc) (GtkWindow *, const gchar *fname, Bankbook *);
typedef gboolean (* FileExportFunc) (GtkWindow *, const gchar *fname, const Bankbook *);

struct _FileFilter
{
  const gchar   *label;   // eg. Tab-delimited text
  FileImportFunc import;
  FileExportFunc export;
};

void file_filter_register   (const FileFilter *);
void file_filter_unregister (const FileFilter *);

/* These lists are sorted alphabetically by label */
GSList *file_import_filters_get (guint *stamp);
GSList *file_export_filters_get (guint *stamp);

/* Check to see if a particular list has changed */
gboolean file_import_filters_changed (guint stamp);
gboolean file_export_filters_changed (guint stamp);

GNOFIN_API_END

#endif
