/******************************************************************************\
 gnofin/record-select.c   $Revision: 1.2 $
 Copyright (C) 2000 Luc Saillard <luc.saillard@alcove.fr>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include "record.h"
#include "record-select.h"

/*
 * Function is_record_view
 * Description:
 *   Test f this record need to be view. For exemple, reconcile dialog 
 *   can use this function to draw only records which isn't cleared.
 * Input: 
 *   record: a valid record struct
 * Output:
 *   a boolean
 */
gboolean is_record_view(const Record *record)
{
  RecordSelect *select=&record->parent->records_select;

  switch (select->method)
   {
    case BEFORE:
      return (g_date_compare((GDate *)&record->date,&(select->date1))<=0);
    case LAST:
    case AFTER:
      return (g_date_compare((GDate *)&record->date,&(select->date1))>=0);
    case BETWEEN:
      return ((g_date_compare((GDate *)&record->date,&(select->date1))>=0) 
	  &&  (g_date_compare((GDate *)&record->date,&(select->date2))<=0));
    case NOTCHECKED:
      return (!record->cleared);
    case ALL:
    default:
      return TRUE;
   }
}

