/******************************************************************************\
 gnofin/html-export.c   $Revision: 1.4 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <string.h>
#include <errno.h>
#include "data-if.h"
#include "dialogs.h"
#include "record-stringizer.h"
#include "html-export.h"
#include "ui-record-list.h"

static void
write_text (FILE *file, gchar *text)
{
  gchar *c;

  trace ("");

  /* html filter.. necessary to translate, for example, "<" to "&lt;" */

  for (c=text; *c; ++c)
  {
    /* process special characters
     * FIXME: are there other characters we should worry about? */

    switch (*c)
    {
    case '<':
      fprintf (file, "&lt;");
      break;
    case '>':
      fprintf (file, "&gt;");
      break;
    case '&':
      fprintf (file, "&amp;");
      break;
    default:
      fprintf (file, "%c", *c);
      break;
    }
  }
}

gboolean
html_export (GtkWindow *parent, const gchar *filename, const Bankbook *book)
{
  FILE *file;
  const GList *ac, *rc;
  UI_RecordListColumnInfo *ci;
  guint ncol;

  trace ("");

  /* We may wish to allow the user to select a particular account to export. */

  file = fopen (filename, "wt");
  if (file == NULL)
  {
    dialog_error (parent, _("Unable to create file: %s"), strerror (errno));
    return FALSE;
  } 

  ncol = ui_record_list_get_column_info (&ci);

  fprintf (file, "<html>\n"
  	 	 "<title>%s</title>\n"
                 "<body bgcolor=white>\n", g_basename (filename));

  for (ac=if_bankbook_get_accounts (book); ac; ac=ac->next)
  {
    Account *account = LIST_DEREF (Account, ac);
    guint i;

    fprintf (file, "<b>%s</b><p>\n" 
    		   "<table border=1>\n", if_account_get_name (account));
    
    fprintf (file, "<tr>");
    for (i=0; i<ncol; i++)
      fprintf (file, "<td><b>%s</b></td>", ci[i].label);
    fprintf (file, "</tr>\n");

    for (rc=if_account_get_records (account); rc; rc=rc->next)
    {
      RecordInfo rec = {0};
      Record *record = LIST_DEREF (Record, rc);
      gchar *text;

      if_record_get_info (record, 0, &rec);

      fprintf (file, "<tr>");
      for (i=0; i<ncol; ++i)
      {
        text = stringize_record_field (NULL, 0, ci[i].field, &rec);
	fprintf (file, "<td>");
	write_text (file, text);
	fprintf (file, "</td>");
	g_free (text);
      }
      fprintf (file, "</tr>\n");
    }
    fprintf (file, "</table><p>\n");
  }
 
  fprintf (file, "</body>\n"
                 "</html>\n");
  fclose (file);
  return TRUE;
}
