/*
 * plugins.c - gnews plugin functions
 * Copyright 2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <glib.h>
#include <gmodule.h>
#include <sys/types.h>
#include <dirent.h>

#include "config.h"
#include "plugins.h"
#include "gnews.h"

GSList *
load_all_plugins (void)
{
  DIR *d;
  struct dirent *de;
  gint len;
  plugindef *pd;
  gchar *plugin;
  GModule *module;
  GSList *slist = NULL;

  if ((d = opendir (PLUGINDIR))) {
    de = readdir (d);
    while (de) {
      len = strlen (de->d_name);
      if ((de->d_name[len - 1] == 'o') && (de->d_name[len - 2] == 's') && (de->d_name[len - 3] == '.')) {
	plugin = g_strconcat (PLUGINDIR, "/", de->d_name, NULL);
#ifdef DEBUG
	g_print ("load plugin from \"%s\"\n", plugin);
#endif
	module = g_module_open (plugin, G_MODULE_BIND_LAZY);
	if (module) {
	  pd = g_malloc (sizeof (plugindef));
	  pd->module = module;
	  if (g_module_symbol (module, "gnews_plugin_get_name", (gpointer) & pd->get_name)) {
	    if (g_module_symbol (module, "gnews_plugin_get_category", (gpointer) & pd->get_category)) {
	      if (g_module_symbol (module, "gnews_plugin_get_url", (gpointer) & pd->get_url)) {
		if (g_module_symbol (module, "gnews_plugin_get_headlines", (gpointer) & pd->get_headlines)) {
		  slist = g_slist_append (slist, pd);
		} else {
		  g_print ("error: `gnews_plugin_get_headlines' not found in %s\n", de->d_name);
		}
	      } else {
		g_print ("error: `gnews_plugin_get_url' not found in %s\n", de->d_name);
	      }
	    } else {
	      g_print ("error: `gnews_plugin_get_category' not found in %s\n", de->d_name);
	    }
	  } else {
	    g_print ("error: `gnews_plugin_get_name' not found in %s\n", de->d_name);
	  }
	  g_free (plugin);
	} else {
	  g_print ("error: %s\n", g_module_error ());
	}
      }
      de = readdir (d);
    }
    closedir (d);
  }
  return (slist);
}

GSList *
load_some_plugins (gchar ** files)
{
  gint i;
  plugindef *pd;
  gchar *plugin;
  GModule *module;
  GSList *slist = NULL;

  if (files != NULL) {
    for (i = 0; files[i] != NULL; i++) {
      plugin = g_strconcat (PLUGINDIR, "/", files[i], NULL);
#ifdef DEBUG
      g_print ("load plugin from \"%s\"\n", plugin);
#endif
      module = g_module_open (plugin, G_MODULE_BIND_LAZY);
      if (module) {
	pd = g_malloc (sizeof (plugindef));
	pd->module = module;
	if (g_module_symbol (module, "gnews_plugin_get_name", (gpointer) & pd->get_name)) {
	  if (g_module_symbol (module, "gnews_plugin_get_category", (gpointer) & pd->get_category)) {
	    if (g_module_symbol (module, "gnews_plugin_get_url", (gpointer) & pd->get_url)) {
	      if (g_module_symbol (module, "gnews_plugin_get_headlines", (gpointer) & pd->get_headlines)) {
		slist = g_slist_append (slist, pd);
	      } else {
		g_print ("error: `gnews_plugin_get_headlines' not found in %s\n", files[i]);
		g_module_close (module);
	      }
	    } else {
	      g_print ("error: `gnews_plugin_get_url' not found in %s\n", files[i]);
	      g_module_close (module);
	    }
	  } else {
	    g_print ("error: `gnews_plugin_get_category' not found in %s\n", files[i]);
	    g_module_close (module);
	  }
	} else {
	  g_print ("error: `gnews_plugin_get_name' not found in %s\n", files[i]);
	  g_module_close (module);
	}
	g_free (plugin);
      } else {
	g_print ("error: %s\n", g_module_error ());
      }
    }
  }
  return (slist);
}

static void
slist_plugin_unload (gpointer data, gpointer user_data)
{
  plugindef *pd;

  pd = data;
#ifdef DEBUG
  g_print ("unload plugin \"%s\":\n", g_basename (g_module_name (pd->module)));
#endif
  if (!g_module_close (pd->module)) {
    g_print ("error: %s\n", g_module_error ());
  }
}

static void
slist_plugin_debug (gpointer data, gpointer user_data)
{
  plugindef *pd;
  gchar *s;

  pd = data;
  s = pd->get_name ();
  g_print ("%s\n", s);
  g_free (s);
  pd->get_headlines ();
}

void
unload_plugins (GSList * plugins)
{
  if (plugins) {
    g_slist_foreach (plugins, slist_plugin_unload, NULL);
  }
}

void
debug_plugins (GSList * plugins)
{
  if (plugins) {
    g_slist_foreach (plugins, slist_plugin_debug, NULL);
  }
}
