with Ada.Text_IO;
with Ada.Integer_Text_IO;

procedure Mutex is

   protected type Counter_Type is
      procedure Set (N : in Integer);
      function Get return Integer;
      procedure Increment;
   private
      Counter : Integer := 0;
   end;

   protected body Counter_Type is

      procedure Set (N : in Integer) is
      begin
         Counter := N;
      end;

      function Get return Integer is
      begin
         return Counter;
      end;

      procedure Increment is
      begin
         Counter := Counter + 1;
      end;

   end;

   Counter : Counter_Type;

begin
   Counter.Set (100);
   Ada.Integer_Text_IO.Put (Counter.Get);
   Ada.Text_Io.New_Line;
   for I in 1..50 loop
      Counter.Increment;
   end loop;
   Ada.Integer_Text_IO.Put (Counter.Get);
   Ada.Text_IO.New_Line;
end;

