/*************
 *
 *    The following gdb commands are supported:
 *
 * command          function                               Return value
 *
 *    g             return the value of the CPU registers  hex data or ENN
 *    G             set the value of the CPU registers     OK or ENN
 *
 *    mAA..AA,LLLL  Read LLLL bytes at address AA..AA      hex data or ENN
 *    MAA..AA,LLLL: Write LLLL bytes at address AA.AA      OK or ENN
 *
 *    c             Resume at current address              SNN   ( signal NN)
 *    cAA..AA       Continue at address AA..AA             SNN
 *
 *    s             Step one instruction                   SNN
 *    sAA..AA       Step one instruction from AA..AA       SNN
 *
 *    k             kill
 *
 *    ?             What was the last sigval ?             SNN   (signal NN)
 *
 *    bBB..BB	    Set baud rate to BB..BB		   OK or BNN, then sets
 *							   baud rate
 *
 * All commands and responses are sent with a packet which includes a
 * checksum.  A packet consists of
 *
 * $<packet info>#<checksum>.
 *
 * where
 * <packet info> :: <characters representing the command or response>
 * <checksum>    :: < two hex digits computed as modulo 256 sum of <packetinfo>>
 *
 * When a packet is received, it is first acknowledged with either '+' or '-'.
 * '+' indicates a successful transfer.  '-' indicates a failed transfer.
 *
 * Example:
 *
 * Host:                  Reply:
 * $m0,10#2a               +$00010203040506070809101112131415#42
 *
 ****************************************************************************/

#define __NEW_STARLET
#include <chfdef>
#include <clidef.h>
#include <dvidef.h>
#include <imcbdef.h>
#include <iodef.h>
#include <iosbdef.h>
#include <jpidef.h>
#include <kferesdef.h>
#include <libdef.h>
#include <lnmdef.h>
#include <pdscdef.h>
#include <secdef.h>
#include <ssdef.h>
#include <va_rangedef.h>

#include <builtins.h>
#include <descrip.h>

/* The definition of lib$callg_64 is *wrong* in lib$routines.h and so
   this header file must be commented out.  The required definitions
   are duplicated below. */
/* #include <lib$routines.h> */

#include <libicb.h>
#include <mman.h>
#include <perror.h>
#include <signal.h>
#include <starlet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define CMA$_EXIT_THREAD 4227492
#define CMA$_FACILITY 64
#define DBGEXT$K_STOP_ALL_OTHER_TASKS 31

/************************************************************************/
/* BUFMAX defines the maximum number of characters in inbound/outbound buffers*/
/* at least NUMREGBYTES*2 are needed for register packets */
#define BUFMAX 2048


/* Copy all the required definitions from lib$routines.h, to get around the
   problem with the lib$callg_64 definition */

#define __optional_params ...

unsigned __int64 lib$callg_64(
	unsigned __int64 argument_list [],
	__int64 (*user_procedure)(void));

unsigned int lib$delete_logical(
	void *logical_name,
	__optional_params);

int lib$get_curr_invo_context(
	void *invo_context);

unsigned int lib$find_image_symbol(
	void *filename,
	void *symbol,
	int *symbol_value,
	__optional_params
	);

unsigned int lib$get_invo_context(
	unsigned int invo_handle,
	void *invo_context);

unsigned int lib$get_invo_handle(
	void *invo_context);

unsigned int lib$get_prev_invo_context(
	void *invo_context);

unsigned int lib$get_prev_invo_handle(
	unsigned int invo_handle);

unsigned int lib$getjpi(
	int *item_code,
	__optional_params
	);

unsigned int lib$match_cond(
	unsigned int *match_condition_value,
	unsigned int *compare_condition_value);

unsigned int lib$put_invo_registers(
	unsigned int invo_handle,
	void *invo_context,
	unsigned __int64 *invo_mask);

unsigned int lib$set_logical(
	void *logical_name,
	__optional_params
	);

int lib$signal(
	unsigned int condition_value,
	__optional_params
	);

#pragma __nostandard			 /* This definition uses non-ANSI-Standard features */
unsigned int lib$spawn(
	__optional_params
	);
#pragma __standard

int decc$$set_get_foreign ();
/* run /debug looks at the 3rd quadword in the image to find where to goto */
void set_debug_traps ();
struct gdb_vector {
  __int64 dummy1;
  __int64 dummy2;
  void (*entry) ();
};
globaldef {"gdb$psect_at_zero"} struct gdb_vector gdb_vector
                                = {0, 0, set_debug_traps};

static VA_RANGE gdbstub_command_line_retadr;

extern IMCB* ctl$gl_imglstptr;

static char _align (page) gdbstub_command_line[1024];

static int initialized = 0;	/* !0 means we've been initialized */
static int initialization_bpt = 0;
static void (*fn_pthread_dbgext)() = 0;

static const char hexchars[]="0123456789abcdef";
static struct dsc$descriptor_s gdb_mbx;
static $DESCRIPTOR(gdbtabledsc, "LNM$GDB");

static unsigned short gdb_chan;

#define NUMREGS 66

/* Number of bytes of registers.  */
#define NUMREGBYTES (NUMREGS * 8)

enum regnames {r0,  r1,  r2,  r3,  r4,  r5,  r6,  r7,
               r8,  r9,  r10, r11, r12, r13, r14, r15,
               a0,  a1,  a2,  a3,  a4,  a5,  r22, r23,
               r24, ai,  ra,  pv,  r28, fp,  sp,  ZERO,

               f0,  f1,  f2,  f3,  f4,  f5,  f6,  f7,
               f8,  f9,  f10, f11, f12, f13, f14, f15,
               fa0, fa1, fa2, fa3, fa4, fa5, f22, f23,
               f24, f25, f26, f27, f28, f29, f30, fzero,
               PC, ps};

static char getbuffer[BUFMAX];
static int  getbuffercnt = 0;
static char* getbufferptr = &getbuffer[0];

static unsigned int ignoredconds[]
   = {LIB$_ACTIMAGE,
      LIB$_KEYNOTFOU};

static int
getDebugChar ()
{
  int status;
  IOSB mbxiosb;
  int c = 0;

  if (getbuffercnt-- > 0)
    return *getbufferptr++;

  sys$qiow (0, gdb_chan, IO$_READVBLK, &mbxiosb, 0, 0,
		&getbuffer[0], BUFMAX, 0, 0, 0, 0);

  getbuffercnt = mbxiosb.iosb$w_bcnt;
  getbuffer [getbuffercnt] = 0;

  getbuffercnt--;
  getbufferptr = &getbuffer[0];
  return (int) *getbufferptr++;
}

static char putbuffer[BUFMAX];
static int  putbuffercnt = 0;
static char* putbufferptr = &putbuffer[0];

static void
putDebugChar (c)
     int c;
{
  putbuffer[putbuffercnt++] = c;
}

static void
putDebugFlush ()
{
  int status;
  IOSB mbxiosb;
  int cnt = putbuffercnt;

  putbuffercnt = 0;
  putbuffer[cnt] = 0;
  sys$qiow (0, gdb_chan, IO$_WRITEVBLK, &mbxiosb, 0, 0,
	    &putbuffer, cnt, 0, 0, 0, 0);
}

/* Convert ch from a hex digit to an int */

static int
hex (ch)
     unsigned char ch;
{
  if (ch >= 'a' && ch <= 'f')
    return ch-'a'+10;
  if (ch >= '0' && ch <= '9')
    return ch-'0';
  if (ch >= 'A' && ch <= 'F')
    return ch-'A'+10;
  return -1;
}

/* scan for the sequence $<data>#<checksum>     */

static void
getpacket (buffer)
     char *buffer;
{
  unsigned char checksum;
  unsigned char xmitcsum;
  int i;
  int count;
  unsigned char ch;

  do
    {
      /* wait around for the start character, ignore all other characters */
      while ((ch = (getDebugChar () & 0x7f)) != '$') ;

      checksum = 0;
      xmitcsum = -1;

      count = 0;

      /* now, read until a # or end of buffer is found */
      while (count < BUFMAX)
	{
	  ch = getDebugChar () & 0x7f;
	  if (ch == '#')
	    break;
	  checksum = checksum + ch;
	  buffer[count] = ch;
	  count = count + 1;
	}

      if (count >= BUFMAX)
	continue;

      buffer[count] = 0;

      if (ch == '#')
	{
	  xmitcsum = hex (getDebugChar () & 0x7f) << 4;
	  xmitcsum |= hex (getDebugChar () & 0x7f);
#if 0
	  /* Humans shouldn't have to figure out checksums to type to it. */
	  putDebugChar ('+');
	  putDebugFlush ();
	  return;
#endif
	  if (checksum != xmitcsum)
	    {
	      putDebugChar ('-');	/* failed checksum */
	      putDebugFlush ();
	    }
	  else
	    {
	      putDebugChar ('+'); /* successful transfer */
	      /* if a sequence char is present, reply the sequence ID */
#if 0 /* I don't know what this is, but it screws up G */
	      if (buffer[2] == ':')
		{
		  putDebugChar (buffer[0]);
		  putDebugChar (buffer[1]);
		  /* remove sequence chars from buffer */
		  count = strlen (buffer);
		  for (i=3; i <= count; i++)
		    buffer[i-3] = buffer[i];
		}
#endif
	      putDebugFlush ();
	    }
	}
    }
  while (checksum != xmitcsum);
}

/* send the packet in buffer.  */

static void
putpacket (buffer)
     unsigned char *buffer;
{
  unsigned char checksum;
  int count;
  unsigned char ch;
  int len = strlen ((const char *) buffer);

  if (len >= BUFMAX)
    printf ("putpacket overflow in gdbstub: %d\n", len);
#if 0
  printf ("putpacket called - length: %d\n", strlen ((const char *) buffer));
  printf ("putpacket called - buffer: %s\n", buffer);
#endif
  /*  $<packet info>#<checksum>. */
  do
    {
      putDebugChar ('$');
      checksum = 0;
      count = 0;

      while (ch = buffer[count])
	{
	  putDebugChar (ch);
	  checksum += ch;
	  count += 1;
	}

      putDebugChar ('#');
      putDebugChar (hexchars[checksum >> 4]);
      putDebugChar (hexchars[checksum & 0xf]);

      putDebugFlush ();
    }
  while ((getDebugChar () & 0x7f) != '+');
}

static char remcomInBuffer[BUFMAX];
static char remcomOutBuffer[BUFMAX];

/* Indicate to caller of mem2hex or hex2mem that there has been an
   error.  */

static volatile int may_fault = 0;
static volatile int did_fault = 0;
static INVO_CONTEXT_BLK may_fault_icb;

/* Convert the memory pointed to by mem into hex, placing result in buf.
 * Return a pointer to the last char put in buf (null), in case of mem fault,
 * return 0.
 * If MAY_FAULT is non-zero, then we will handle memory faults by returning
 * a 0, else treat a fault like any other fault in the stub.
 */

static unsigned char *
mem2hex (mem, buf, count)
     unsigned char *mem;
     unsigned char *buf;
     int count;
{
  unsigned char ch;

  if (may_fault)
    {
      lib$get_curr_invo_context (&may_fault_icb);
      lib$get_prev_invo_context (&may_fault_icb);
    }

  while (count-- > 0)
    {
      ch = *mem++;
      *buf++ = hexchars[ch >> 4];
      *buf++ = hexchars[ch & 0xf];
    }

  *buf = 0;

  return buf;
}

/* convert the hex array pointed to by buf into binary to be placed in mem
 * return a pointer to the character AFTER the last byte written */

static char *
hex2mem (buf, mem, count)
     unsigned char *buf;
     unsigned char *mem;
     int count;
{
  unsigned int i;
  unsigned char ch;
  unsigned int startpage, endpage;

  if (may_fault)
    {
      lib$get_curr_invo_context (&may_fault_icb);
      lib$get_prev_invo_context (&may_fault_icb);
    }

  startpage = (unsigned int) mem/8192;
  endpage = ((unsigned int) mem + count - 1) /8192;

#if 0
  printf ("mprotect - st: %d to %d\n", startpage, endpage);
#endif

  for (i=startpage; i<=endpage; i++)
    if (mprotect ( (void*)(i*8192), 8192, PROT_WRITE))
      return 0;

  for (i=0; i<count; i++)
    {
      ch = hex (*buf++) << 4;
      ch |= hex (*buf++);
#if 0
      printf ("hex2mem writing %x at %x\n", ch, mem);
#endif
      *mem++ = ch;
    }

  /* ??? FIXME - reprotect? */

  return (char *) mem;
}

/* This table contains the mapping between VMS condition types, and
   signals, which are primarily what GDB understands. */

static struct hard_trap_info
{
  unsigned int tt;		/* Trap type code */
  unsigned char signo;		/* Signal that we map this trap into */
} hard_trap_info[] = {
  {5,          SIGINT},         /* ^C seems to generate this ... */
  {SS$_ACCVIO, SIGSEGV},	/* instruction access error */
  {SS$_BREAK,  SIGTRAP},	/* bpt - normal breakpoint instruction */
  {4227492,    SIGINT},         /* thread exited */
  {0, 0}			/* Must be last */
};

static int
computeSignal (tt)
     int tt;
{
  struct hard_trap_info *ht;

  for (ht = hard_trap_info; ht->tt && ht->signo; ht++)
    if (ht->tt == tt)
      return ht->signo;

  return SIGHUP;		/* default for things we don't know about */
}

/*
 * While we find nice hex chars, build an int.
 * Return number of chars processed.
 */

static int
hexToInt (char **ptr, int *intValue)
{
  int numChars = 0;
  int hexValue;

  *intValue = 0;

  while (**ptr)
    {
      hexValue = hex (**ptr);
      if (hexValue < 0)
	break;

      *intValue = (*intValue << 4) | hexValue;
      numChars ++;

      (*ptr)++;
    }

  return (numChars);
}

/*
 * While we find nice hex chars, build an int.
 * Return number of chars processed.
 */

static int
hexToInt64 (char **ptr, unsigned __int64 *intValue)
{
  int numChars = 0;
  int hexValue;

  *intValue = 0;

  while (**ptr)
    {
      hexValue = hex (**ptr);
      if (hexValue < 0)
	break;

      *intValue = (*intValue << 4) | hexValue;
      numChars ++;

      (*ptr)++;
    }

  return (numChars);
}

static unsigned int
exit_handler (status)
     unsigned int *status;
{
  unsigned int unix_status = *status;
  char *ptr;

  ptr = remcomOutBuffer;
  *ptr++ = 'W';
  ptr = (char *) mem2hex ((char *)&unix_status, ptr, 4);
  *ptr++ = 0;
  putpacket (remcomOutBuffer);
  lib$delete_logical (&gdb_mbx, &gdbtabledsc);
  return 0;
}

static unsigned int exit_status;

static  struct {
    unsigned int *desblk;
    unsigned int (*exh)();
    unsigned int argcount;
    unsigned int *cndvaladdr;
  } exitblock = {0, &exit_handler, 1, &exit_status};


/*
 * This function does all command procesing for interfacing to gdb.  It
 * returns 1 if you should skip the instruction at the trap address, 0
 * otherwise.
 */

static const __int64 zero = 0;

int
gdb_stub_handler (sigargs, mechargs)
     CHFDEF1 *sigargs;
     CHFDEF2 *mechargs;
{
  int tt;			/* Trap type */
  int sigval;
  int addr;
  int length;
  char *ptr;
  INVO_CONTEXT_BLK curr_icb;
  long curr_invo_handle;
  int status;
  unsigned __int64 registers_changed_mask;
  long control_block [11] = {0,0,0,0,0,0,0,0,0,0,0};
  int former_ast_status;
  long former_task_status;
  __int64 pc;
  char message [16];

  if (lib$match_cond ((unsigned int *) &sigargs->chf$is_sig_name,
		      &ignoredconds[0])
      || lib$match_cond ((unsigned int *) &sigargs->chf$is_sig_name,
			 &ignoredconds[1]))
    return SS$_RESIGNAL;

#if 0
  printf ("stub handler entered: %d at %x\n",
	  sigargs->chf$is_sig_name,
	  ((long *)(&sigargs->chf$is_sig_arg1))[sigargs->chf$is_sig_args-3]);
#endif

  if (may_fault)
    {
      unsigned __int64 new_r0 = 0;
      unsigned __int64 new_r1 = 0;
      unsigned long may_fault_handle = lib$get_invo_handle (&may_fault_icb);

      did_fault = sigargs->chf$is_sig_name;

      sys$goto_unwind (&may_fault_handle, 0, &new_r0, &new_r1);
    }

  if (fn_pthread_dbgext)
    {
      control_block [0] = (CMA$_FACILITY << 16)
	| (DBGEXT$K_STOP_ALL_OTHER_TASKS);
      control_block [10] = 0; /* Disable task scheduling */
      (fn_pthread_dbgext) (control_block); 
      former_task_status = control_block [10];
    }

  former_ast_status = sys$setast (0); /* Disable ASTs */

  message[0] = 0;
  if (! ((sigargs->chf$is_sig_name == SS$_BREAK)
	 || (sigargs->chf$is_sig_name == 5))) /* ^C */
    {
        unsigned short outlen;
        int msg_flag = 0x0002; /* 1 bit for each of the four message parts */
        struct dsc$descriptor_s msgdesc;

        msgdesc.dsc$w_length = 15;
	msgdesc.dsc$b_dtype = DSC$K_DTYPE_T;
	msgdesc.dsc$b_class = DSC$K_CLASS_S;
        msgdesc.dsc$a_pointer = message;

        SYS$GETMSG (sigargs->chf$is_sig_name, &outlen, &msgdesc, msg_flag, 0);
        message[outlen] = 0;
    }


  registers_changed_mask = 0;
  status = lib$get_curr_invo_context (&curr_icb);
  status = lib$get_prev_invo_context (&curr_icb);
  status = lib$get_prev_invo_context (&curr_icb);
  curr_invo_handle = lib$get_invo_handle (&curr_icb);
  tt = sigargs->chf$is_sig_name;

  /* reply to host that an exception has occurred */
  sigval = computeSignal (tt);
  ptr = remcomOutBuffer;

  *ptr++ = 'T';
  ptr = (char *) mem2hex ((char *)&tt, ptr, 4);

  if (message [0])
    {
      char *messagep = message;
      while (*messagep)
	*ptr++ = *messagep++;
      *ptr++ = '%';
    }

  *ptr++ = hexchars[PC >> 4];
  *ptr++ = hexchars[PC & 0xf];
  *ptr++ = ':';

  /* PC always points to instruction after BP, but we want to resume
     at the BP instruction (after it's replaced with its original
     contents, of course). */
  if (!initialization_bpt && (tt == SS$_BREAK))
    ((long *)(&sigargs->chf$is_sig_arg1))[sigargs->chf$is_sig_args-3] -= 4;
  pc = ((long *)(&sigargs->chf$is_sig_arg1))[sigargs->chf$is_sig_args-3];

  ptr = (char *) mem2hex ((char *)&pc, ptr, 8);
  *ptr++ = ';';

  *ptr++ = hexchars[fp >> 4];
  *ptr++ = hexchars[fp & 0xf];
  *ptr++ = ':';
  ptr = (char *) mem2hex ((char *)&curr_icb.libicb$q_ireg [fp], ptr, 8);
  *ptr++ = ';';

  *ptr++ = hexchars[sp >> 4];
  *ptr++ = hexchars[sp & 0xf];
  *ptr++ = ':';
  ptr = (char *) mem2hex ((char *)&curr_icb.libicb$q_ireg [sp], ptr, 8);
  *ptr++ = ';';

  *ptr++ = 0;

  putpacket (remcomOutBuffer);

  while (1)
    {
      remcomOutBuffer[0] = 0;

      getpacket (remcomInBuffer);
      switch (remcomInBuffer[0])
	{
	case '?':
	  remcomOutBuffer[0] = 'S';
	  remcomOutBuffer[1] = hexchars[sigval >> 4];
	  remcomOutBuffer[2] = hexchars[sigval & 0xf];
	  remcomOutBuffer[3] = 0;
	  break;

	case 'A':
#if 0
	  printf ("Args: '%s'\n", &remcomInBuffer[0]);
#endif
	  strcpy (gdbstub_command_line_retadr.va_range$ps_start_va,
		  &remcomInBuffer[1]);
	  strcpy (remcomOutBuffer, "OK");
	  break;

	/* cAA..AA    Continue at address AA..AA(optional) */
	case 'c':
	  /* try to read optional parameter, pc unchanged if no parm */

	  {
	    long status;

	    ptr = &remcomInBuffer[1];
	    if (hexToInt (&ptr, &addr))
	      {
		curr_icb.libicb$q_program_counter = addr;
		((long *)(&sigargs->chf$is_sig_arg1))
		  [sigargs->chf$is_sig_args-3] = addr;
	      }
	    if (registers_changed_mask)
	      {
		printf ("registers_changed_mask: %llx\n",
			registers_changed_mask);
		lib$put_invo_registers
		  (curr_invo_handle, &curr_icb, &registers_changed_mask);
	      }

/* 
   Need to flush the instruction cache here, as we may have deposited a
   breakpoint, and the icache probably has no way of knowing that a data ref to
   some location may have changed something that is in the instruction cache.
*/

#if 0
	    flush_i_cache ();
#endif

	    former_ast_status = sys$setast (former_ast_status);

	    if (fn_pthread_dbgext)
	      {
		control_block [0] = (CMA$_FACILITY << 16)
		  | (DBGEXT$K_STOP_ALL_OTHER_TASKS);
		control_block [10] = former_task_status;
		(fn_pthread_dbgext) (control_block); 
	      }

	    /* The following block needs to be enhanced to coordinate with
	       the "handle" table in GDB. ??? */

	    if (sigargs->chf$is_sig_name == SS$_BREAK
		|| sigargs->chf$is_sig_name == 5)
	      {
		return SS$_CONTINUE;
	      }
	    else
	      {
		return SS$_RESIGNAL;
	      }
		
/*	    if (sigargs->chf$is_sig_name == CMA$_EXIT_THREAD)
	      return SS$_RESIGNAL;
	    else
	      return SS$_CONTINUE; */
	  }

	case 'C':                /* Call function */
	  /* Cfuncaddr:numargs;arg1addr:arg2addr:...:argnaddr; */
	  {

	    __int64 (*funcaddr)();
	    int numargs;
	    unsigned __int64 retval;
	    unsigned __int64 arg_list [255];
	    int i;

	    ptr = &remcomInBuffer[1];

	    if (hexToInt (&ptr, (int *) &funcaddr)
		&& *ptr++ == ':'
		&& hexToInt (&ptr, &numargs)
		&& *ptr++ == ';')
	      {
		arg_list [0] = numargs;
		i = 1;
		for (i=1; i<=numargs; i++)
		  {
		    int deref = 0;
		    int isreg = 0;

		    if (*ptr == '*')      /* Dereference this address */
		      {
			deref = 1;
			ptr++;
		      }
		    else if (*ptr == '%') /* Register number */
		      {
			isreg = 1;
			ptr++;
		      }

		    hexToInt64 (&ptr, &arg_list [i]);

		    if (deref)
		      arg_list [i] = * (char*)arg_list [i];
		    else if (isreg)
		      arg_list [i] = curr_icb.libicb$q_ireg [arg_list[i]];

		    *ptr++;
		  }


		may_fault = 1;
		did_fault = 0;
		lib$get_curr_invo_context (&may_fault_icb);
#if 0
		printf ("calling Procedure descriptor: %x\n", funcaddr);
		for (i=1;i<=numargs;i++)
		  printf ("arg %d: 0x%llx, %lld\n",
			  i, arg_list[i], arg_list[i]);
#endif
		retval = (unsigned __int64) lib$callg_64 (arg_list, funcaddr);
		may_fault = 0;
		if (did_fault)
		  {
		    sprintf (remcomOutBuffer, "E%d", did_fault);
		  }
		else
		  {
#if 0
		    printf ("call returning %llx (%lld)\n", retval, retval);
#endif
		    ptr = remcomOutBuffer;
		    ptr = (char *) mem2hex ((char *)&retval, ptr, 8);
		  }
	      }
	  }
	  
	  break;

	case 'd':
				/* toggle debug flag */
	  break;

	case 'g':		/* return the value of the CPU registers */
	  {
	    int i;

	    ptr = remcomOutBuffer;
	    for (i=0; i<=30; i++)
	      {
		ptr = (char *) mem2hex
		  ((char *)&curr_icb.libicb$q_ireg [i], ptr, 8);
	      }
	    ptr = (char *) mem2hex ((char *)&zero, ptr, 8);

	    for (i=0; i<=30; i++)
	      {
		ptr = (char *) mem2hex
		  ((char *)&curr_icb.libicb$q_freg [i], ptr, 8);
	      }
	    ptr = (char *) mem2hex ((char *)&zero, ptr, 8);

	    ptr = (char *) mem2hex ((char *)&pc, ptr, 8);
	    ptr = (char *) mem2hex
	      ((char *)&curr_icb.libicb$q_processor_status, ptr, 8);
	    *ptr = 0;
	    break;
	  }

	/* set the value of the CPU registers - return OK */
	case 'G':
	  {
	    int regno;
	    unsigned __int64 regval;
	    long status;

	    ptr = &remcomInBuffer[1];
	    if (hexToInt (&ptr, &regno)
		&& *ptr++ == ':'
		&& hexToInt64 (&ptr, &regval))
	      {
		if (regno < 31)
		  {
		    printf ("Setting regno: %d to %llx\n", regno, regval);
		    curr_icb.libicb$q_ireg [regno] = regval;
		    registers_changed_mask |= 1 << regno;
		  }
	        
		else if (regno == PC)
		  {
		    curr_icb.libicb$q_program_counter = regval;
		    registers_changed_mask |= 0x80000000;
		    ((long *)(&sigargs->chf$is_sig_arg1))
		      [sigargs->chf$is_sig_args-3] = regval;
		  }
	      }
	    strcpy (remcomOutBuffer,"OK");
	  }
	  break;

	case 'h':                /* Get previous or current invo handle */
	  /* hhandle or h */
	  {
	    int prev_handle, handle;
	    
	    ptr = &remcomInBuffer[1];
	    if (hexToInt (&ptr, &handle))
	      {
		prev_handle = lib$get_prev_invo_handle (handle);
	      }
	    else
	      {
		prev_handle = curr_invo_handle;
	      }
	
	    ptr = remcomOutBuffer;
	    ptr = (char *) mem2hex ((char *)&prev_handle, ptr, 4);
	  }
	  break;

	case 'i':
	  {
	    ptr = remcomOutBuffer;
	    ptr = (char *) mem2hex ((char *)&ctl$gl_imglstptr, ptr, 4);
	  }
	  break;

	  /* kill the program */
	  /* Don't call C exit(), because it can trigger a pthread bugcheck.
	     In a nutshell, the bugcheck happens because $EXIT is executed
	     from within a null thread-a lethal combination. 
	     The kernel and DECthreads share responsibility for image exit.
	     The kernel supports a protocol involving $EXIT, kernel thread
	     context, and upcalls, which allows DECthreads to manage an
	     image's termination. For instance, DECthreads uses a special
	     thread to execute exit handlers, to prevent conflicts with
	     user-created threads. In this case, the GDB process has
	     interfered with this protocol, by the apparent means of
	     asynchronously taking control in the target process and
             causing $EXIT to be called from within an internal DECthreads
	     thread. The net result is the kernel makes an unexpected upcall
             to the null thread and change to its scheduling context. This
	     causes a sort of recursion, reported by the bugcheck as an
	     invalid dispatch attempt. Some alternative approaches for
	     handling kill are: 1) have the foreground GDB process simply
	     delete the target process via $DELPRC, or 2) use $FORCEX
	     (which will still allow the exit handlers to run since the
	     defined exit protocol will be maintained).
	     Explanation by Thomas Dahl of Compaq */
	case 'k':
          {
            long status = 0;

	    /* Cancel the exit handler since we're calling it explicitly
	       and we don't want it to get called twice */
	    sys$canexh (&exitblock);
            exit_handler (&status);
            exit (status);
#if 0
            sys$delprc (0, 0);
#endif
          }
	  break;

	/* mAA..AA,LLLL  Read LLLL bytes at address AA..AA */
	case 'm':
	  /* Try to read %x,%x.  */

	  ptr = &remcomInBuffer[1];

	  if (hexToInt (&ptr, &addr)
	      && *ptr++ == ','
	      && hexToInt (&ptr, &length))
	    {
#if 0
	      printf ("m: wants to read at %x\n", addr);
#endif
	      may_fault = 1;
	      did_fault = 0;
	      if (mem2hex ((char *)addr, remcomOutBuffer, length))
		{
		  may_fault = 0;
		  break;
		}
	      may_fault = 0;
	      strcpy (remcomOutBuffer, "E03");
	    }
	  else
	    strcpy (remcomOutBuffer,"E01");
	  break;

	/* MAA..AA,LLLL: Write LLLL bytes at address AA.AA return OK */
	case 'M':
	  /* Try to read '%x,%x:'.  */

	  ptr = &remcomInBuffer[1];

	  if (hexToInt (&ptr, &addr)
	      && *ptr++ == ','
	      && hexToInt (&ptr, &length)
	      && *ptr++ == ':')
	    {
#if 0
	      printf ("M: wants to write at %x\n", addr);
#endif
	      may_fault = 1;
	      did_fault = 0;
	      if (hex2mem (ptr, (char *)addr, length))
		{
		  may_fault = 0;
		  strcpy (remcomOutBuffer, "OK");
		}
	      else
		{
		  may_fault = 0;
		  strcpy (remcomOutBuffer, "E03");
		}
	    }
	  else
	    {
	      strcpy (remcomOutBuffer, "E02");
	    }
	  break;

	case 'p':                 /* Get procedure descriptor */
	  /* dhandle */
	  {
	    int handle;
	    int status;
	    INVO_CONTEXT_BLK icb;
	    PDSCDEF *pdsc;

	    ptr = &remcomInBuffer[1];
	    if (hexToInt (&ptr, &handle))
	      {
		lib$get_invo_context (handle, &icb);
		pdsc = (PDSCDEF *)icb.libicb$ph_procedure_descriptor;
		
		ptr = remcomOutBuffer;

		ptr = (char *) mem2hex ((char *)&icb.libicb$r_frameflags,
				       ptr, 1);
		*ptr++ = ';';

		if (pdsc->pdsc$v_base_reg_is_fp)
		  ptr = (char *) mem2hex ((char *)&icb.libicb$q_ireg [fp],
					 ptr, 8);
		else
		  ptr = (char *) mem2hex ((char *)&icb.libicb$q_ireg [sp],
					 ptr, 8);

		*ptr++ = ';';
		if (pdsc->pdsc$v_kind == PDSC$K_KIND_NULL)
		  {
		    printf ("null frame\n");
		    ptr = (char *) mem2hex ((char *)pdsc,
					    ptr,
					    PDSC$K_NULL_SIZE);
		  }
		else if (pdsc->pdsc$v_kind == PDSC$K_KIND_FP_REGISTER)
		  {
		    ptr = (char *) mem2hex ((char *)pdsc,
					    ptr,
					    PDSC$K_MIN_REGISTER_SIZE);
		  }
		else if (pdsc->pdsc$v_kind == PDSC$K_KIND_FP_STACK)
		  {
		    ptr = (char *) mem2hex ((char *)pdsc,
					    ptr,
					    PDSC$K_MIN_STACK_SIZE);
		  }
		else
		  {
		    printf ("Unknown descriptor kind: %d\n",
			    pdsc->pdsc$v_kind);
		  }

		/* The previous frame's PC */
		*ptr++ = ';';
		lib$get_prev_invo_context (&icb);
		ptr = (char *) mem2hex ((char *)&icb.libicb$q_program_counter,
					 ptr, 8);
	      }
	  }
	  break;
	  
	case 'r':		/* Reset */
	  break;

	case 'w':                /* Pop designated frame */
	  /* whandle */
	  {
	    int handle;
	    
	    ptr = &remcomInBuffer[1];
	    if (hexToInt (&ptr, &handle))
	      {
		sys$goto_unwind
		  (&handle, 0,
		   (unsigned __int64 *) &curr_icb.libicb$q_ireg [r0],
		   (unsigned __int64 *) &curr_icb.libicb$q_ireg [r1]);
	      }
	
	  }
	  break;

	default:
	  printf ("Unknown stub command: %c\n", remcomInBuffer[0]);
	  printf ("InBuffer: %s\n", remcomInBuffer);

	}			/* switch */

      /* reply to the request */
      putpacket (remcomOutBuffer);
    }

}

static void
breakpoint ()
{
  initialization_bpt = 1;
#ifdef __GNUC__
  asm ("bpt");
#else
  __PAL_BPT();
#endif
  initialization_bpt = 0;
}

static struct {
  unsigned short buflen, item_code;
  void *bufaddr;
  void *retlenaddr;
  unsigned int terminator;
} itm_lst;

void
set_debug_traps ()
{
  int i, len, maxargs;
  char *pos, *oldpos;
  void *prvhnd;
  int status;
  char mboxbuff[16];
  char pscbuff[16];
  int namelen;
  int itemcode;
  IMCB *imcb;
  int mypid = getpid ();
  int myppid = getppid ();
  int spawn_gdb = 0;
  int gdb_mbx_exists = 0;
  int jpi_itemcode = JPI$_IMAGNAME;
  unsigned int attr = LNM$M_CASE_BLIND;
  short jpi_length;
  struct dsc$descriptor_s jpi_imagename;
  struct dsc$descriptor_s gdb_mbx;
  unsigned int mbx_dev_len;
  char mbx_dev_buff [64];
  struct dsc$descriptor_s mbx_dev;

#if 0
  printf ("Initializing GDB stub: %x son of %x\n", mypid, myppid);
#endif

  sprintf (mboxbuff, "gdbmbox%x", mypid);
  gdb_mbx.dsc$w_length = strlen (mboxbuff);
  gdb_mbx.dsc$b_dtype = DSC$K_DTYPE_T;
  gdb_mbx.dsc$b_class = DSC$K_CLASS_S;
  gdb_mbx.dsc$a_pointer = mboxbuff;

  /* 
     There are three ways to get here:

     1) Gdb spawns the target.
     2) The target is run with /debug
     3) The target is run, then Gdb attaches

     If 2) then target must spawn Gdb.
  */

  if (myppid == 0)
    {
      /* If parent pid == 0, then either 2) or 3) above is true */

      spawn_gdb = 1;
    }
  else
    {
      /* Target is spawned, but did Gdb do it? */

      jpi_imagename.dsc$w_length = BUFMAX;
      jpi_imagename.dsc$b_dtype = DSC$K_DTYPE_T;
      jpi_imagename.dsc$b_class = DSC$K_CLASS_S;
      jpi_imagename.dsc$a_pointer = putbuffer;
      lib$getjpi (&jpi_itemcode, &myppid, 0, 0, &jpi_imagename, &jpi_length);
      putbuffer [jpi_length] = 0;
      if (!strstr (putbuffer, "]GDB.EXE;"))
	{
	  /* Parent is not Gdb, maybe we have to spawn Gdb */

	  spawn_gdb = 1;
	}
    }

  itm_lst.buflen = 64;
  itm_lst.item_code = LNM$_STRING;
  itm_lst.bufaddr = mbx_dev_buff;
  itm_lst.retlenaddr = &mbx_dev_len;
  itm_lst.terminator = 0;

  status = sys$trnlnm
    (&attr,      /* attr */
     &gdbtabledsc,  /* tabnam */
     &gdb_mbx,   /* lognam */
     0,          /* acmode */
     &itm_lst);

  if (status == SS$_NOLOGNAM)
    {
      gdb_mbx_exists = 0;
    }
  else if (status == SS$_NORMAL)
    {
      gdb_mbx_exists = 1;
    }

  if (spawn_gdb)
    {
      /* if this mailbox exists then this is an attach
	 command and we don't want to spawn GDB */

      if (gdb_mbx_exists)
	{
	  spawn_gdb = 0;
	}

    }

  if (!gdb_mbx_exists)
    {
      sys$crembx
	(0,          /* pmmflg */
	 &gdb_chan,  /* chan */
	 BUFMAX,     /* maxmsg */
	 BUFMAX,     /* bufquo */
	 0,          /* promsk */
	 0,          /* acmode */
	 0,          /* lognam */
	 0,          /* flags */
	 0);         /* nullarg */

      itm_lst.buflen = 64;
      itm_lst.item_code = DVI$_DEVNAM;
      itm_lst.bufaddr = mbx_dev_buff;
      itm_lst.retlenaddr = &mbx_dev_len;
      itm_lst.terminator = 0;

      sys$getdviw
	(0,          /* efn */
	 gdb_chan,   /* chan */
	 0,          /* devnam */
	 &itm_lst,   /* itmlst */
	 0,          /* iosb */
	 0,          /* astadr */
	 0,          /* astprm */
	 0);         /* nullarg */

      mbx_dev.dsc$w_length = strlen (mbx_dev_buff);
      mbx_dev.dsc$b_dtype = DSC$K_DTYPE_T;
      mbx_dev.dsc$b_class = DSC$K_CLASS_S;
      mbx_dev.dsc$a_pointer = mbx_dev_buff;;

      status = lib$set_logical (&gdb_mbx, &mbx_dev, &gdbtabledsc, 0, 0);

      if (status == SS$_NOLOGTAB)
	printf ("GDB Logical Name Table not found, see release notes.\n");

      if ((status & 1) != 1)
	lib$signal (status);

    }
  else
    {
      mbx_dev.dsc$w_length = strlen (mbx_dev_buff);
      mbx_dev.dsc$b_dtype = DSC$K_DTYPE_T;
      mbx_dev.dsc$b_class = DSC$K_CLASS_S;
      mbx_dev.dsc$a_pointer = mbx_dev_buff;;

      sys$assign (&mbx_dev, &gdb_chan, 0, 0, 0);
    }

  {
    VA_RANGE gdbstub_command_line_inadr =
      {&gdbstub_command_line [0], &gdbstub_command_line [1023]};

    struct dsc$descriptor_s gdbstub_psc;
    sprintf (pscbuff, "gdbstub%x", mypid);
    gdbstub_psc.dsc$w_length = strlen (pscbuff);
    gdbstub_psc.dsc$b_dtype = DSC$K_DTYPE_T;
    gdbstub_psc.dsc$b_class = DSC$K_CLASS_S;
    gdbstub_psc.dsc$a_pointer = pscbuff;

    decc$$set_get_foreign ("GDBSTUB_GET_FOREIGN",
				    "GNU:[LIB].EXE",
				    "GDBSTUB_GET_FOREIGN");

#if 0
    printf ("gdbstub gsdnam: %s\n", gdbstub_psc.dsc$a_pointer);
    printf ("gdbstub inadr: %x - %x\n",
	    gdbstub_command_line_inadr.va_range$ps_start_va,
	    gdbstub_command_line_inadr.va_range$ps_end_va);
#endif

    sys$crmpsc
      (&gdbstub_command_line_inadr,  /* inadr */
       &gdbstub_command_line_retadr, /* retadr */
       0,                            /* acmode */
       SEC$M_GBL | SEC$M_EXPREG | SEC$M_PAGFIL,     /* flags */
       &gdbstub_psc,                 /* gsdnam */
       0,                            /* ident */
       0,                            /* relpag */
       0,                            /* chan */
       1,                            /* pagcnt */
       0,                            /* vbn */
       0,                            /* prot */
       0                             /* pfc */
       );

#if 0
    printf ("gdbstub retadr: %x - %x\n",
	    gdbstub_command_line_retadr.va_range$ps_start_va,
	    gdbstub_command_line_retadr.va_range$ps_end_va);
    printf ("crmpsc status: %x\n", status);
#endif


  }

#if 1
  for (imcb = ctl$gl_imglstptr->imcb$l_flink;
       imcb != ctl$gl_imglstptr;
       imcb = imcb->imcb$l_flink)
    {
      strncpy (remcomOutBuffer,
	       &imcb->imcb$t_log_image_name [1],
	       imcb->imcb$t_log_image_name [0]);
      remcomOutBuffer [imcb->imcb$t_log_image_name[0]] = 0;

      if (strcmp (remcomOutBuffer, "PTHREAD$RTL"))
	{
	  struct dsc$descriptor_s imagname
	    = {11, DSC$K_DTYPE_T, DSC$K_CLASS_S, "PTHREAD$RTL"};
	  struct dsc$descriptor_s symname
	    = {14, DSC$K_DTYPE_T, DSC$K_CLASS_S, "PTHREAD$DBGEXT"};

	  status
	    = lib$find_image_symbol
	      (&imagname, &symname, (int *)&fn_pthread_dbgext, 0);

	  if ((status & 1) != 1)
	    lib$signal (status);

	  break;
	}
    }
#endif

#if 1 /* Doesn't work sometimes for some reason. */
  sys$dclexh (&exitblock);
#endif

  if (spawn_gdb)
    {
      struct dsc$descriptor_s commanddsc;
      static int spawnstatus;
      int spawnflags;

      jpi_imagename.dsc$w_length = BUFMAX;
      jpi_imagename.dsc$b_dtype = DSC$K_DTYPE_T;
      jpi_imagename.dsc$b_class = DSC$K_CLASS_S;
      jpi_imagename.dsc$a_pointer = putbuffer;
      lib$getjpi (&jpi_itemcode, &mypid, 0, 0, &jpi_imagename, &jpi_length);
      putbuffer [jpi_length] = 0;
      sprintf (getbuffer, "mcr gnu:[bin]gdb -slave %x %s", mypid, putbuffer);

      commanddsc.dsc$w_length = strlen (getbuffer);
      commanddsc.dsc$b_dtype = DSC$K_DTYPE_T;
      commanddsc.dsc$b_class = DSC$K_CLASS_S;
      commanddsc.dsc$a_pointer = getbuffer;

      spawnflags = CLI$M_NOWAIT;

      lib$spawn
	(&commanddsc,           /* command-string */
	 0,                     /* input-file  */
	 0,                     /* output-file */
	 &spawnflags,           /* flags */
	 0,                     /* process-name */
	 0,                     /* process-id */
	 &spawnstatus,          /* completion-status-address */
	 0,                     /* byte-integer-event-flag-num */
	 0,                     /* AST-address */
	 0,                     /* AST-argument */
	 0,                     /* prompt-string */
	 0,                     /* cli */
	 0);                    /* table */
    }

  initialized = 1;

  sys$setexv (0, gdb_stub_handler, 3, &prvhnd);

  /* Trigger the initialization breakpoint */

  breakpoint ();
}
