#ifndef __PARSE_EXT_H
#define __PARSE_EXT_H

/* data required for all shares */
typedef struct {
   char *filename; /* full dos-style pathname */
   char *checksum; /* 32 byte MD5 checksum */
   
   time_t mtime;   /* last modified */
   time_t time;    /* total playing time (in seconds) */
   
   unsigned long filesize;   /* file size (in bytes) */
   
   unsigned short bitrate;   /* kbps */
   unsigned short frequency; /* frequency (in Hz) */   
} ShareData;

typedef struct {
   char *name;
   char *mimetype;
   
   ShareData *(*parse) (char *file, int fd);
   int (*ext) (char *ext);
} ParseExt;

#define REGISTER_EXT(a,b,c,d) register_ext_funcs(a, b, c, d)

/* prototypes */
void register_exts();
void register_ext_funcs(char *name, char *mimetype, void *parse, void *ext);
char *get_mime_packet(char *packet);
char *get_mime_type(char *file);
char *get_ext(char *file);
void write_share(int writefd, ShareData *shr);
void process_file(STab *stab, int writefd, char *path);
void recursive_parse_start(STab *stab, int writefd, char *root);
void recursive_parse(STab *stab, int writefd, char *dirpath);
/* !prototypes */

#endif /* __PARSE_EXT_H */
