/* utilities for manipulating GtkCList and GtkCTree */

#include "gnapster.h"

GtkCTreeNode *tree_find_node(GtkWidget *ctree, char *s) {
   return tree_real_find_node(GTK_CTREE(ctree), NULL, s);
}

GtkCTreeNode *tree_real_find_node(GtkCTree *ctree, GtkCTreeNode *node, char *s) {
   GtkCTreeNode *work;
   char *buf;
   
   if (!node)
     node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
   
   for(; node; node=GTK_CTREE_ROW(node)->sibling) {
      buf = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
      
      if (!j_strcmp(buf, s))
	return node;
      
      if (GTK_CTREE_ROW(node)->children &&
	  (work = tree_real_find_node(ctree, GTK_CTREE_ROW(node)->children, s)))
        return work;
   }
      
   return NULL;
}

GtkCTreeNode *tree_insert_node(GtkWidget *ctree, GtkCTreeNode *node, int leaf, void *data, ...) {
   va_list args;
   GList *ap = NULL;
   char *s;
   int ll;
   
   va_start(args, data);
   for(;;) {
      s = va_arg(args, char *);
      if (!s)
	break;
      
      ap = g_list_append(ap, s);
   }
   va_end(args);
   
   ll = g_list_length(ap);
     {
	char *add[ll + 1];
	GList *ptr;
	int x = 0;
	
	for(ptr=ap; ptr; ptr=ptr->next)
	  add[x++] = ptr->data;
	
	add[x] = NULL;
	
	node = gtk_ctree_insert_node(GTK_CTREE(ctree), node, NULL,
				     add, 0, NULL, NULL, NULL, NULL, leaf, 0);
	
	if (data)
	  gtk_ctree_node_set_row_data_full(GTK_CTREE(ctree), node, data,
					   (GtkDestroyNotify)gnapster_destroy);
     }
   
   g_list_free(ap);
   
   return node;
}

GtkCTreeNode *tree_first_node(GtkWidget *ctree) {
   return GTK_CTREE_NODE(GTK_CLIST(GTK_CTREE(ctree))->row_list);
}

