------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-envcreate80.adb,v 1.5 2004/06/28 04:57:05 vagul Exp $

package body OCI.EnvCreate80 is

   Flag : Boolean := False;

   -----------------------
   -- Not_Implemented_2 --
   -----------------------

   function Not_Implemented_2 return SWord is
   begin
      raise Not_Implemented_In_This_Version;
      return OCI_ERROR;
   end Not_Implemented_2;

   ------------------
   -- OCIEnvCreate --
   ------------------

   function OCIEnvCreate
     (Envh      : access OCIEnv;
      Mode      : in     Ub4;
      Ctxp      : in     Undefined;
      Malocfp   : in     Undefined;
      Ralocfp   : in     Undefined;
      Mfreefp   : in     Undefined;
      Xtramemsz : in     Undefined;
      Usrmempp  : in     Undefined)
      return SWord
   is
      use type Ub4;
      use type SWord;
      Init_Mode : Ub4 := 0;
      Rc : SWord;
   begin
      if not Flag then
         Rc := OCIInitialize
           (mode    => Mode and (OCI_THREADED
                               + OCI_OBJECT
                               + OCI_EVENTS
                               + OCI_SHARED),
            Ctxp    => Ctxp,
            Malocfp => Malocfp,
            Ralocfp => Ralocfp,
            Mfreefp => Mfreefp);

         if Rc = OCI_SUCCESS then
            Flag := True;
         else
            return Rc;
         end if;
      end if;

      if (Mode and OCI_NO_UCB) /= 0 then
         Init_Mode := OCI_ENV_NO_UCB;
      end if;

      if (Mode and OCI_NO_MUTEX) /= 0 then
         Init_Mode := Init_Mode or OCI_ENV_NO_MUTEX;
      end if;

      return OCIEnvInit (Envh, Init_Mode, Xtramemsz, Usrmempp);
   end OCIEnvCreate;

   function OCILobCreateTemporary
     (svchp    : OCISvcCtx;
      errhp    : OCIError;
      locp     : OCILobLocator;
      csid     : Ub2;
      csfrm    : Ub1;
      lobtype  : Ub1;
      cache    : C.int;
      duration : OCIDuration)
      return SWord is
   begin
      raise Not_Implemented_In_This_Version;
      return OCI_ERROR;
   end OCILobCreateTemporary;

end OCI.EnvCreate80;
