/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_LIST_H
#define GM_LIST_H

typedef enum { STRING, INT, OBJECT, FLOAT, LIST, ERROR } MOOType;
enum MOOError { E_NONE, E_TYPE, E_DIV, E_PERM, E_PROPNF, E_VERBNF, E_VARNF, E_INVIND, E_RECMOVE, E_MAXREC, E_RANGE, E_ARGS, E_NACC, E_INVARG, E_QUOTA, E_FLOAT };
typedef struct _MOOVar MOOVar;
struct _MOOVar {
    MOOType type; /* The type of the var */
    char *s;      /* The scring val or the error desc */
    int   i;      /* The int val, list length or string lengt or error code */
    double d;     /* The float val */
    MOOVar *list; /* The first list item (if type == LIST) */
    MOOVar *next; /* The next list item (if avalible) */
};

MOOVar *MOOVar_new_list();
MOOVar *MOOVar_new_object(int obj);
MOOVar *MOOVar_new_string(const char *string);
MOOVar *MOOVar_new_error(const char *try_error); /* return NULL on error */
MOOVar *MOOVar_new_float(const char *d);
MOOVar *MOOVar_new_int(const char *i);
void    MOOVar_free(MOOVar *var);

MOOVar *MOOVar_parse(const char *s);
void    MOOVar_listappend(MOOVar *var, MOOVar *item);
MOOVar *MOOVar_listindex(MOOVar *list, int index);
char   *MOOVar_tostr(MOOVar *v);


typedef struct {
    char *buf;
    int pos;
    int len;
} stream_t;

stream_t *stream_new(int len);
void      stream_append(stream_t *s, char c);
void      stream_append_string(stream_t *s, const char *string);
void      stream_append_string_quoted(stream_t *s, const char *string);
void      stream_free(stream_t *s);


#endif /* GM_LIST_H */
