/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>

#include "config.h"

#include "colorsel.h"

#define new_item(menu, text, func)\
item = gtk_menu_item_new_with_label(text);\
gtk_widget_show(item);\
gtk_container_add(GTK_CONTAINER(menu), item);\
gtk_signal_connect(GTK_OBJECT(item), "activate",\
		   GTK_SIGNAL_FUNC(func), c);\
gtk_signal_connect(GTK_OBJECT(item), "activate",\
		   GTK_SIGNAL_FUNC(col_changed_cb), c)

void color_button_set_color(GtkWidget *button,gushort r, gushort g, gushort b);
extern gushort **color_palettes[];
extern gushort **fgbg_palettes[];

void gm_colorsel_free(d_colorsel_t *c) {
    g_free(c);
}


void col_color_cb(GtkWidget *w, d_colorsel_t *c) {
    int value = g_list_index(GTK_MENU_SHELL(GTK_OPTION_MENU(c->color)
                                            ->menu)->children,
                             GTK_OPTION_MENU(c->color)->menu_item);
    int i;
    if(debug)
        printf("color palette changed from %d to %d\n", c->s->color_palette,
               value);
    c->s->color_palette = value;
    if(value) {
        for(i = 0; i < 16; i++) {
            gtk_widget_set_sensitive(c->colors[i], FALSE);
            color_button_set_color(c->colors[i],
                                   color_palettes[value - 1][0][i],
                                   color_palettes[value - 1][1][i],
                                   color_palettes[value - 1][2][i]);
        }
    } else {
        for(i = 0; i < 16; i++) {
            gtk_widget_set_sensitive(c->colors[i], TRUE);
            color_button_set_color(c->colors[i],
                                   c->s->reds[i],
                                   c->s->greens[i],
                                   c->s->blues[i]);
        }
    }
}

void col_fgbg_cb(GtkWidget *w, d_colorsel_t *c) {
    int value = g_list_index(GTK_MENU_SHELL(GTK_OPTION_MENU(c->fgbg)
                                            ->menu)->children,
                             GTK_OPTION_MENU(c->fgbg)->menu_item);
    int i;
    if(debug) printf("fgbg palette changed from %d to %d\n", c->s->fgbg_palette,
                     value);
    c->s->fgbg_palette = value;
    if(value) {
        for(i = 0; i < 2; i++) {
            gtk_widget_set_sensitive(c->colors[i + 16], FALSE);
            color_button_set_color(c->colors[i + 16],
                                   fgbg_palettes[value - 1][0][i],
                                   fgbg_palettes[value - 1][1][i],
                                   fgbg_palettes[value - 1][2][i]);
        }
    } else {
        for(i = 0; i < 2; i++) {
            gtk_widget_set_sensitive(c->colors[i + 16], TRUE);
            color_button_set_color(c->colors[i + 16],
                                   c->s->reds[i + 16],
                                   c->s->greens[i + 16],
                                   c->s->blues[i + 16]);
        }
    }
}


void col_changed_cb(GtkWidget *w, d_colorsel_t *c) {
    gtk_widget_set_sensitive(c->pc->ok, TRUE);
    gtk_widget_set_sensitive(c->pc->apply, TRUE);
}

void set_color(GdkColor *c, gushort r, gushort g, gushort b);
void color_button_set_color(GtkWidget *button,
			    gushort r, gushort g, gushort b) {
    GtkStyle  *style;
    GtkWidget *w = gtk_object_get_data(GTK_OBJECT(button), "draw");
    GdkColor *c = gtk_object_get_data(GTK_OBJECT(button), "GdkColor");

    set_color(c, r, g, b);
    
    style = gtk_style_copy(gtk_widget_get_style(w));
    memcpy(&style->bg[GTK_STATE_NORMAL], c, sizeof(GdkColor));
    memcpy(&style->bg[GTK_STATE_INSENSITIVE], c, sizeof(GdkColor));
    gtk_widget_set_style(w, style);

    /* why doesn't queue_draw work ??? */
    gtk_widget_hide(w);
    gtk_widget_show(w);
}

extern GtkWidget *main_window;
void free_the_color(GtkWidget *w) {
    GdkColor *c = gtk_object_get_data(GTK_OBJECT(w), "GdkColor");
    if(c->pixel) {
        if(debug)
            printf("Destroying color %x/%x/%x\n", c->red, c->green, c->blue);
        gdk_colormap_free_colors(gtk_widget_get_colormap(main_window), c, 1);
    }
}

GtkWidget *color_button_new() {
    GtkWidget *button;
    GtkWidget *frame;
    GtkWidget *w;
    GdkColor *c;
    
    button = gtk_button_new();
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button), "destroy", free_the_color, NULL);

    frame = gtk_frame_new(NULL);
    gtk_widget_show(frame);
    gtk_container_add(GTK_CONTAINER(button), frame);
    gtk_container_border_width(GTK_CONTAINER(frame), 1);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);

    w = gtk_drawing_area_new();
    gtk_widget_show(w);
    gtk_container_add(GTK_CONTAINER(frame), w);
    gtk_drawing_area_size(GTK_DRAWING_AREA(w), 20, 12);
    gtk_object_set_data(GTK_OBJECT(button), "draw", w);

    c = g_malloc(sizeof(GdkColor));
    c->pixel = 0;
    gtk_object_set_data(GTK_OBJECT(button), "GdkColor", c);

    return button;
}

void col_csd_ok(GtkWidget *but, d_colorsel_t *c) {
    int pos = (int) gtk_object_get_data(GTK_OBJECT(but), "pos");
    GtkWidget *csd = gtk_widget_get_toplevel(but);
    double d[3];

    if(debug) {
        printf("color changed for color %d\n", pos);
        printf("\tfrom: %x %x %x\n",
               c->s->reds[pos], c->s->greens[pos], c->s->blues[pos]);
    }
    
    gtk_color_selection_get_color(GTK_COLOR_SELECTION(
        GTK_COLOR_SELECTION_DIALOG(csd)->colorsel), d);
    gtk_widget_hide(csd);
    gtk_widget_destroy(csd);

    c->s->reds[pos]   = d[0] * 0xffff;
    c->s->greens[pos] = d[1] * 0xffff;
    c->s->blues[pos]  = d[2] * 0xffff;

    if(debug) 
        printf("\tto  : %x %x %x\n", c->s->reds[pos],
               c->s->greens[pos], c->s->blues[pos]);

    color_button_set_color(c->colors[pos],
                           c->s->reds[pos],
                           c->s->greens[pos],
                           c->s->blues[pos]);
    col_changed_cb(NULL, c);
}

void col_button_cb(GtkWidget *but, d_colorsel_t *c) {
    GtkWidget *csd;
    int i;
    double d[3];

    for(i = 0; c->colors[i] != but; i++);
    csd = gtk_color_selection_dialog_new(i == 16 ? _("Foreground color") :
					 i == 17 ? _("Background color") :
					 _("Select a color"));
    d[0] = c->s->reds[i] / 65535.;
    d[1] = c->s->greens[i] / 65535.;
    d[2] = c->s->blues[i] / 65535.;
    gtk_color_selection_set_color(
        GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(csd)->
			    colorsel), d);
    gtk_window_set_modal(GTK_WINDOW(csd), TRUE);
    gtk_window_set_position(GTK_WINDOW(csd), GTK_WIN_POS_MOUSE);

    gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(csd)->help_button);
    gtk_signal_connect_object(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(csd)->
					 cancel_button), "clicked",
			      GTK_SIGNAL_FUNC(gtk_widget_destroy),
			      GTK_OBJECT(csd));
    gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(csd)->
				  ok_button), "clicked",
		       GTK_SIGNAL_FUNC(col_csd_ok),
		       c);
    gtk_object_set_data(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(csd)->ok_button),
			"pos", (void *) i);

    gtk_widget_show(csd);
}

d_colorsel_t *gm_colorsel_create_properties(GtkTable *table, settings_t *s) {
    GtkWidget *tmp;
    GtkWidget *menu;
    GtkWidget *item;
    GtkWidget *table2;
    int i;
    d_colorsel_t *c = g_malloc(sizeof(d_colorsel_t));
    c->s = s;

    gtk_table_resize(table, 5, 3);
    
    tmp = gtk_label_new(_("Color scheme"));
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 1, 0.5);
    gtk_table_attach(table, tmp, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);

    c->color = gtk_option_menu_new();
    gtk_widget_show(c->color);
    gtk_table_attach(table, c->color, 1, 2, 0, 1, GTK_FILL, 0, 0, 0);

    menu = gtk_menu_new();
    gtk_widget_show(menu);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(c->color), menu);

    new_item(menu, _("Custom"), col_color_cb);
    new_item(menu, _("Linux"), col_color_cb);
    new_item(menu, _("Color XTerm"), col_color_cb);
    new_item(menu, _("Rxvt"), col_color_cb);

    tmp = gtk_label_new(_("Fore/Background color"));
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 1, 0.5);
    gtk_table_attach(table, tmp, 0, 1, 1, 2, GTK_FILL, 0, 0, 0);
   
    c->fgbg = gtk_option_menu_new();
    gtk_widget_show(c->fgbg);
    gtk_table_attach(table, c->fgbg, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);

    menu = gtk_menu_new();
    gtk_widget_show(menu);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(c->fgbg), menu);

    new_item(menu, _("Custom"), col_fgbg_cb);
    new_item(menu, _("White on Black"), col_fgbg_cb);
    new_item(menu, _("Black on White"), col_fgbg_cb);
    new_item(menu, _("Green on Black"), col_fgbg_cb);

    tmp = gtk_label_new(_("Foreground color"));
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 1, 0.5);
    gtk_table_attach(table, tmp, 0, 1, 2, 3, GTK_FILL, 0, 0, 0);

    c->colors[16] = color_button_new(0, 0, 0);
    gtk_table_attach(table, c->colors[16], 1, 2, 2, 3, 0, 0, 0, 0);
    gtk_signal_connect(GTK_OBJECT(c->colors[16]), "clicked",
		       GTK_SIGNAL_FUNC(col_button_cb), c);

    
    tmp = gtk_label_new(_("Background color"));
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 1, 0.5);
    gtk_table_attach(table, tmp, 0, 1, 3, 4, GTK_FILL, 0, 0, 0);
   
    c->colors[17] = color_button_new(0, 0, 0);
    gtk_table_attach(table, c->colors[17], 1, 2, 3, 4, 0, 0, 0, 0);
    gtk_signal_connect(GTK_OBJECT(c->colors[17]), "clicked",
		       GTK_SIGNAL_FUNC(col_button_cb), c);

    tmp = gtk_label_new(_("Color palette"));
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 1, 0.5);
    gtk_table_attach(table, tmp, 0, 1, 4, 5, GTK_FILL, 0, 0, 0);
   
    table2 = gtk_table_new(2, 8, FALSE);
    gtk_widget_show(table2);
    gtk_table_attach(table, table2, 1, 2, 4, 5, GTK_FILL, 0, 0, 0);

    for(i = 0; i < 16; i++) {
	c->colors[i] = color_button_new(0, 0, 0);
	gtk_table_attach(GTK_TABLE(table2), c->colors[i],
			 i > 7 ? i - 8 : i,
			 i > 7 ? i - 7 : i + 1,
			 i > 7 ? 1 : 0,
			 i > 7 ? 2 : 1,
			 0, 0, 0, 0);
	gtk_signal_connect(GTK_OBJECT(c->colors[i]), "clicked",
			   GTK_SIGNAL_FUNC(col_button_cb), c);

    }

    gtk_option_menu_set_history(GTK_OPTION_MENU(c->color), s->color_palette);
    gtk_option_menu_set_history(GTK_OPTION_MENU(c->fgbg),  s->fgbg_palette);

    col_color_cb(NULL, c);
    col_fgbg_cb(NULL, c);
	
    return c;
}

