#ifdef HAVE_CONFIG_H  
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "mfsk.h"
#include "macro.h"
#include "prefs.h"
#include "ptt.h"

struct preferences prefs;
struct preferences tmp_prefs;

GdkFont *rxfont, *txfont;

#define	DEFAULT_FONT	"-*-lucidatypewriter-medium-r-*-*-12-*-*-*-*-*-*-*"

/* ---------------------------------------------------------------------- */

#define confcpy(d,s)	{ strncpy((d),(s),sizeof(d)); d[sizeof(d)-1] = 0; }

static int color_to_int(GdkColor *color)
{
	int ret = 0;

	ret |= (color->red   & 0xff00) << 8;
	ret |= (color->green & 0xff00);
	ret |= (color->blue  & 0xff00) >> 8;

	return ret;
}

static void alloc_color(GdkColor *color, int c)
{
	GdkColormap *cmap;

	color->red   = (0xff0000 & c) >> 8;
	color->green = (0x00ff00 & c);
	color->blue  = (0x0000ff & c) << 8;

	cmap = gdk_colormap_get_system();

	if (!gdk_color_alloc(cmap, color))
		g_error("couldn't allocate color");
}


static void entry_changed(GtkEditable *editable, gpointer user_data)
{
	GtkWidget *propertybox;
	gchar *entry = (gchar *) user_data;

	propertybox = gtk_widget_get_toplevel(GTK_WIDGET(editable));
	gnome_property_box_changed(GNOME_PROPERTY_BOX(propertybox));

	strncpy(entry, gtk_entry_get_text(GTK_ENTRY(editable)), 64);
	entry[63] = 0;
}

static void color_set(GnomeColorPicker *gnomecolorpicker,
		guint arg1,
		guint arg2,
		guint arg3,
		guint arg4,
		gpointer user_data)
{
	GtkWidget *propertybox;
	GdkColor *color = (GdkColor *) user_data;
	int value = 0;

	propertybox = gtk_widget_get_toplevel(GTK_WIDGET(gnomecolorpicker));
	gnome_property_box_changed(GNOME_PROPERTY_BOX(propertybox));

	value |= (arg1 & 0xff00) << 8;
	value |= (arg2 & 0xff00);
	value |= (arg3 & 0xff00) >> 8;

	alloc_color(color, value);
}

static void font_set(GnomeFontPicker *gnomefontpicker,
		gchar *arg1,
		gpointer user_data)
{
	GtkWidget *propertybox;
	gchar *font = (gchar *) user_data;

	propertybox = gtk_widget_get_toplevel(GTK_WIDGET(gnomefontpicker));
	gnome_property_box_changed(GNOME_PROPERTY_BOX(propertybox));

	strncpy(font, arg1, 256);
	font[255] = 0;
}

static void button_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkWidget *propertybox;
	gboolean *flag = (gboolean *) user_data;

	propertybox = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	gnome_property_box_changed(GNOME_PROPERTY_BOX(propertybox));

	if (togglebutton->active)
		*flag = TRUE;
	else
		*flag = FALSE;
}

static void spinbutton_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
	GtkWidget *propertybox;
	gfloat *value = (gfloat *) user_data;

	propertybox = gtk_widget_get_toplevel(GTK_WIDGET(spinbutton));
	gnome_property_box_changed(GNOME_PROPERTY_BOX(propertybox));

	*value = gtk_spin_button_get_value_as_float(spinbutton);
}

static void color_picker_set(GnomeColorPicker *cp, GdkColor *clr)
{
	gnome_color_picker_set_i16(cp, clr->red, clr->green, clr->blue, 0);
}

/* ---------------------------------------------------------------------- */

void apply_config(GtkWidget *widget)
{
	GnomePropertyBox *propertybox;
	gint i;

	propertybox = GNOME_PROPERTY_BOX(widget);

	if (strcmp(prefs.rx_font, tmp_prefs.rx_font))
		rxfont = gdk_font_load(tmp_prefs.rx_font);

	if (strcmp(prefs.tx_font, tmp_prefs.tx_font))
		txfont = gdk_font_load(tmp_prefs.tx_font);

	if (strcmp(prefs.pttdev, tmp_prefs.pttdev) ||
	    prefs.pttinv != tmp_prefs.pttinv)
		init_ptt(tmp_prefs.pttdev, tmp_prefs.pttinv);

	if (strcmp(prefs.sounddev, tmp_prefs.sounddev) ||
	    prefs.eightbitsound != tmp_prefs.eightbitsound ||
	    prefs.fullduplexsound != tmp_prefs.fullduplexsound ||
	    prefs.testmode != tmp_prefs.testmode)
		push_button("pausebutton");

	/*
	 * Copy the temp config back to the real one.
	 */
	prefs = tmp_prefs;

	gnome_config_set_string("/gmfsk/info/mycall",  prefs.mycall);
	gnome_config_set_string("/gmfsk/info/myname",  prefs.myname);
	gnome_config_set_string("/gmfsk/info/myqth",   prefs.myqth);
	gnome_config_set_string("/gmfsk/info/myloc",   prefs.myloc);
	gnome_config_set_string("/gmfsk/info/myemail", prefs.myemail);

	i = color_to_int(&prefs.hl_color);
	gnome_config_set_int("/gmfsk/colors/hl", i);

	i = color_to_int(&prefs.rx_color);
	gnome_config_set_int("/gmfsk/colors/rx", i);

	i = color_to_int(&prefs.tx_color);
	gnome_config_set_int("/gmfsk/colors/tx", i);

	i = color_to_int(&prefs.tx_win_color);
	gnome_config_set_int("/gmfsk/colors/txwin", i);

	i = color_to_int(&prefs.rx_win_color);
	gnome_config_set_int("/gmfsk/colors/rxwin", i);

	gnome_config_set_string("/gmfsk/fonts/rxfont", prefs.rx_font);
	gnome_config_set_string("/gmfsk/fonts/txfont", prefs.tx_font);

	gnome_config_set_float("/gmfsk/misc/txoffset", prefs.txoffset);
	gnome_config_set_float("/gmfsk/misc/sqval",    prefs.sqval);

	gnome_config_set_bool("/gmfsk/misc/afc",       prefs.afc);
	gnome_config_set_bool("/gmfsk/misc/squelch",   prefs.squelch);

	gnome_config_set_string("/gmfsk/sound/dev",    prefs.sounddev);
	gnome_config_set_bool("/gmfsk/sound/8bit",     prefs.eightbitsound);
	gnome_config_set_bool("/gmfsk/sound/fulldup",  prefs.fullduplexsound);
	gnome_config_set_bool("/gmfsk/sound/testmode", prefs.testmode);

	gnome_config_set_string("/gmfsk/ptt/dev",      prefs.pttdev);
	gnome_config_set_bool("/gmfsk/ptt/inverted",   prefs.pttinv);

	gnome_config_sync();
}

void load_config(void)
{
	gchar *p;
	gint i;
	gboolean b;
	gfloat f;

	p = gnome_config_get_string("/gmfsk/info/mycall=");
	confcpy(prefs.mycall, p);
	g_free(p);

	p = gnome_config_get_string("/gmfsk/info/myname=");
	confcpy(prefs.myname, p);
	g_free(p);

	p = gnome_config_get_string("/gmfsk/info/myqth=");
	confcpy(prefs.myqth, p);
	g_free(p);

	p = gnome_config_get_string("/gmfsk/info/myloc=");
	confcpy(prefs.myloc, p);
	g_free(p);

	p = gnome_config_get_string("/gmfsk/info/myemail=");
	confcpy(prefs.myemail, p);
	g_free(p);


	i = gnome_config_get_int("/gmfsk/colors/hl=255");
	alloc_color(&prefs.hl_color, i);

	i = gnome_config_get_int("/gmfsk/colors/rx=0");
	alloc_color(&prefs.rx_color, i);

	i = gnome_config_get_int("/gmfsk/colors/tx=16711680");
	alloc_color(&prefs.tx_color, i);

	i = gnome_config_get_int("/gmfsk/colors/rxwin=16777215");
	alloc_color(&prefs.rx_win_color, i);

	i = gnome_config_get_int("/gmfsk/colors/txwin=16777215");
	alloc_color(&prefs.tx_win_color, i);


	p = gnome_config_get_string("/gmfsk/fonts/rxfont=" DEFAULT_FONT);
	confcpy(prefs.rx_font, p);
	g_free(p);
	rxfont = gdk_font_load(prefs.rx_font);

	p = gnome_config_get_string("/gmfsk/fonts/txfont=" DEFAULT_FONT);
	confcpy(prefs.tx_font, p);
	g_free(p);
	txfont = gdk_font_load(prefs.tx_font);


	f = gnome_config_get_float("/gmfsk/misc/txoffset=0");
	prefs.txoffset = f;

	f = gnome_config_get_float("/gmfsk/misc/sqval=15");
	prefs.sqval = f;


	b = gnome_config_get_bool("/gmfsk/misc/afc=FALSE");
	prefs.afc = b;

	b = gnome_config_get_bool("/gmfsk/misc/squelch=FALSE");
	prefs.squelch = b;


	p = gnome_config_get_string("/gmfsk/sound/dev=/dev/dsp");
	confcpy(prefs.sounddev, p);
	g_free(p);

	b = gnome_config_get_bool("/gmfsk/sound/8bit=FALSE");
	prefs.eightbitsound = b;

	b = gnome_config_get_bool("/gmfsk/sound/fulldup=FALSE");
	prefs.fullduplexsound = b;

	b = gnome_config_get_bool("/gmfsk/sound/testmode=FALSE");
	prefs.testmode = b;


	p = gnome_config_get_string("/gmfsk/ptt/dev=none");
	confcpy(prefs.pttdev, p);
	g_free(p);

	b = gnome_config_get_bool("/gmfsk/ptt/inverted=FALSE");
	prefs.pttinv = b;
}

void fill_config(GtkWidget *widget)
{
	GnomePropertyBox *propertybox;
	gpointer p;

	propertybox = GNOME_PROPERTY_BOX(widget);

	/*
	 * Copy the real config to a temp struct.
	 */
	tmp_prefs = prefs;

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "callentry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.mycall);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.mycall);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "nameentry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.myname);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.myname);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "qthentry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.myqth);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.myqth);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "locentry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.myloc);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.myloc);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "emailentry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.myemail);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.myemail);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "hlcolorpicker");
	color_picker_set(GNOME_COLOR_PICKER(p), &prefs.hl_color);
	gtk_signal_connect(GTK_OBJECT(p), "color_set",
			   GTK_SIGNAL_FUNC(color_set),
			   &tmp_prefs.hl_color);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "rxcolorpicker");
	color_picker_set(GNOME_COLOR_PICKER(p), &prefs.rx_color);
	gtk_signal_connect(GTK_OBJECT(p), "color_set",
			   GTK_SIGNAL_FUNC(color_set),
			   &tmp_prefs.rx_color);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "txcolorpicker");
	color_picker_set(GNOME_COLOR_PICKER(p), &prefs.tx_color);
	gtk_signal_connect(GTK_OBJECT(p), "color_set",
			   GTK_SIGNAL_FUNC(color_set),
			   &tmp_prefs.tx_color);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "txwincolorpicker");
	color_picker_set(GNOME_COLOR_PICKER(p), &prefs.tx_win_color);
	gtk_signal_connect(GTK_OBJECT(p), "color_set",
			   GTK_SIGNAL_FUNC(color_set),
			   &tmp_prefs.tx_win_color);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "rxwincolorpicker");
	color_picker_set(GNOME_COLOR_PICKER(p), &prefs.rx_win_color);
	gtk_signal_connect(GTK_OBJECT(p), "color_set",
			   GTK_SIGNAL_FUNC(color_set),
			   &tmp_prefs.rx_win_color);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "rxfontpicker");
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(p), prefs.rx_font);
	gnome_font_picker_set_mode(GNOME_FONT_PICKER(p),
				   GNOME_FONT_PICKER_MODE_FONT_INFO);
	gtk_signal_connect(GTK_OBJECT(p), "font_set",
			   GTK_SIGNAL_FUNC(font_set),
			   tmp_prefs.rx_font);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "txfontpicker");
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(p), prefs.tx_font);
	gnome_font_picker_set_mode(GNOME_FONT_PICKER(p),
				   GNOME_FONT_PICKER_MODE_FONT_INFO);
	gtk_signal_connect(GTK_OBJECT(p), "font_set",
			   GTK_SIGNAL_FUNC(font_set),
			   tmp_prefs.tx_font);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "txoffsetspinbutton");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(p), prefs.txoffset);
	gtk_signal_connect (GTK_OBJECT(p), "changed",
			    GTK_SIGNAL_FUNC(spinbutton_changed),
			    &tmp_prefs.txoffset);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "squelchspinbutton");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(p), prefs.sqval);
	gtk_signal_connect (GTK_OBJECT(p), "changed",
			    GTK_SIGNAL_FUNC(spinbutton_changed),
			    &tmp_prefs.sqval);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "afccheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.afc);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.afc);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "squelchcheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.squelch);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.squelch);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "sound_combo_entry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.sounddev);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.sounddev);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "eightbitcheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.eightbitsound);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.eightbitsound);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "rwcheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.fullduplexsound);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.fullduplexsound);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "testcheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.testmode);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.testmode);


	p = gtk_object_get_data(GTK_OBJECT(propertybox), "ptt_combo_entry");
        gtk_entry_set_text(GTK_ENTRY(p), prefs.pttdev);
	gtk_signal_connect(GTK_OBJECT(p), "changed",
			   GTK_SIGNAL_FUNC(entry_changed),
			   tmp_prefs.pttdev);

	p = gtk_object_get_data(GTK_OBJECT(propertybox), "pttinvcheckbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p), prefs.pttinv);
	gtk_signal_connect (GTK_OBJECT(p), "toggled",
			    GTK_SIGNAL_FUNC(button_toggled),
			    &tmp_prefs.pttinv);
}

/* ---------------------------------------------------------------------- */


