#ifndef _MFSK_H
#define _MFSK_H

#include <gnome.h>

#include "complex.h"

#define	SampleRate	8000
#define	SymbolLen	512
#define	BaseTone	64
#define	NumTones	16
#define	SymbolRate	((float)SampleRate/SymbolLen)
#define	ToneSpacing	SymbolRate

#define	TxQueueSize	64
#define	PipeLen		(2*SymbolLen)

struct rxpipe {
	complex vector[NumTones];
	int symbol;
};

struct mfskrx {
	struct filter *hilbert;
	struct slfft *slfft;
	struct viterbi *viterbi;

	struct rxpipe pipe[PipeLen];
	unsigned int pipeptr;

	unsigned int datashreg;

	complex currvector;
	complex prev1vector;
	complex prev2vector;

	int currsymbol;
	int prev1symbol;
	int prev2symbol;

	float freq;
	float phaseacc;

	long int prevmetric;
	float averagemetric;

	unsigned int symbolphase;
	unsigned int symboltime;
	float syncaverage;
	int counter;
};

struct mfsktx {
	struct fft *fft;

	float freq;
	float phaseacc;

	float queue[TxQueueSize][SymbolLen];
	int queuelen;
	int queueptr;

	unsigned int bitshreg;
	int bitstate;

	unsigned int encstate;

	int state;
	int counter;
	int stopflag;
	int tune;
};

#define	STATE_PREAMBLE	0
#define	STATE_START	1
#define	STATE_DATA	2
#define	STATE_END	3
#define	STATE_FLUSH	4
#define	STATE_FINISH	5
#define	STATE_TUNE	6

/* in main.c */
extern GtkWidget *appwindow;
extern GtkWidget *PopupMenu;
extern gboolean TXon;
extern gboolean AFCon;
extern gboolean SQUELCHon;
extern gboolean WFpause;
extern GdkColor rx_color;
extern GdkColor hl_color;
extern GdkColor tx_color;
extern void errmsg(const gchar *fmt, ...);
extern void start_tx(void);
extern void start_rx(void);
extern void stop_trx(gboolean abort);
extern void trx_set_freq(float freq);
extern void start_tune(void);
extern void stop_tune(void);
extern void update_metric_dial(float metric);

/* in mfskrx.c */
extern struct mfskrx *initrx(void);
extern void rxprocess(struct mfskrx *m, float *buf, int len);

/* in mfsktx.c */
extern struct mfsktx *inittx(void);
extern void txstop(struct mfsktx *m);
extern float *txprocess(struct mfsktx *m);

/* in typeahead.c */
extern void typeahead_put_char(unsigned char c);
extern void typeahead_put_string(unsigned char *s);
extern void typeahead_del_char(void);
extern int typeahead_get_char(void);
extern void typeahead_clear(void);

/* in rxtext.c */
extern void show_rx_char(unsigned int c);
extern void show_tx_char(unsigned int c);
extern gint log_to_file_start(const gchar *name);
extern void log_to_file_stop(void);
extern gchar *log_to_file_get_name(void);

/* in bitshape.c */
extern void bitshape_init(void);
extern void bitshape_draw(struct mfskrx *m);

#endif
