
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 *
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#include <gdome.h>


#include "GdomeSmartDOMBasic.hh"
#include "GdomeSmartDOMDOMImplementation.hh"
#include "GdomeSmartDOMCore.hh"


namespace GdomeSmartDOM {

Document::Document(GdomeDocument* obj)

  : Node((GdomeNode*) obj) { }
  Document::Document(const Document& obj)
  
  : Node(obj)
      
{
  
}

  Document::Document(const Node& obj)
  
  : Node((GdomeNode*) gdome_cast_doc(obj.gdome_object()))
      
{
  
}

  Document& Document::operator=(const Document& obj)
{
  if (this == &obj) return *this;

  GdomeException exc_ = 0;

  if (gdome_obj != 0) {

    gdome_doc_unref((GdomeDocument*) gdome_obj, &exc_);
  

    gdome_obj = 0;
  }
  
  if (exc_ == 0) {
    gdome_obj = obj.gdome_obj;

    if (gdome_obj != 0) gdome_doc_ref((GdomeDocument*) gdome_obj, &exc_);
  
  }
  
  if (exc_ != 0) throw DOMException(exc_, "Document::operator=");

  return *this;
}

bool Document::operator==(const Document& obj) const
{
  return gdome_obj == obj.gdome_obj;
}

Document::~Document()
{
  
}

DocumentType Document::get_doctype() const
{
  GdomeException exc_;
  GdomeDocumentType* res_ = gdome_doc_doctype((GdomeDocument*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Document::get_doctype");
  return DocumentType(res_);
}

DOMImplementation Document::get_implementation() const
{
  GdomeException exc_;
  GdomeDOMImplementation* res_ = gdome_doc_implementation((GdomeDocument*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Document::get_implementation");
  return DOMImplementation(res_);
}

Element Document::get_documentElement() const
{
  GdomeException exc_;
  GdomeElement* res_ = gdome_doc_documentElement((GdomeDocument*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Document::get_documentElement");
  return Element(res_);
}

Element Document::createElement(const DOMString& tagName) const
{
  GdomeException exc_;
  GdomeDOMString* tagName_ = GdomeDOMString_of_DOMString(tagName);
  GdomeElement* res_ = gdome_doc_createElement((GdomeDocument*) gdome_obj, tagName_, &exc_);
  
  if (tagName_ != 0) gdome_str_unref(tagName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createElement");
  return Element(res_);
}

DocumentFragment Document::createDocumentFragment() const
{
  GdomeException exc_;
  GdomeDocumentFragment* res_ = gdome_doc_createDocumentFragment((GdomeDocument*) gdome_obj, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createDocumentFragment");
  return DocumentFragment(res_);
}

Text Document::createTextNode(const DOMString& data) const
{
  GdomeException exc_;
  GdomeDOMString* data_ = GdomeDOMString_of_DOMString(data);
  GdomeText* res_ = gdome_doc_createTextNode((GdomeDocument*) gdome_obj, data_, &exc_);
  
  if (data_ != 0) gdome_str_unref(data_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createTextNode");
  return Text(res_);
}

Comment Document::createComment(const DOMString& data) const
{
  GdomeException exc_;
  GdomeDOMString* data_ = GdomeDOMString_of_DOMString(data);
  GdomeComment* res_ = gdome_doc_createComment((GdomeDocument*) gdome_obj, data_, &exc_);
  
  if (data_ != 0) gdome_str_unref(data_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createComment");
  return Comment(res_);
}

CDATASection Document::createCDATASection(const DOMString& data) const
{
  GdomeException exc_;
  GdomeDOMString* data_ = GdomeDOMString_of_DOMString(data);
  GdomeCDATASection* res_ = gdome_doc_createCDATASection((GdomeDocument*) gdome_obj, data_, &exc_);
  
  if (data_ != 0) gdome_str_unref(data_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createCDATASection");
  return CDATASection(res_);
}

ProcessingInstruction Document::createProcessingInstruction(const DOMString& target, const DOMString& data) const
{
  GdomeException exc_;
  GdomeDOMString* target_ = GdomeDOMString_of_DOMString(target);
  GdomeDOMString* data_ = GdomeDOMString_of_DOMString(data);
  GdomeProcessingInstruction* res_ = gdome_doc_createProcessingInstruction((GdomeDocument*) gdome_obj, target_, data_, &exc_);
  
  if (target_ != 0) gdome_str_unref(target_);
  
  if (data_ != 0) gdome_str_unref(data_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createProcessingInstruction");
  return ProcessingInstruction(res_);
}

Attr Document::createAttribute(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeAttr* res_ = gdome_doc_createAttribute((GdomeDocument*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createAttribute");
  return Attr(res_);
}

EntityReference Document::createEntityReference(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeEntityReference* res_ = gdome_doc_createEntityReference((GdomeDocument*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createEntityReference");
  return EntityReference(res_);
}

NodeList Document::getElementsByTagName(const DOMString& tagname) const
{
  GdomeException exc_;
  GdomeDOMString* tagname_ = GdomeDOMString_of_DOMString(tagname);
  GdomeNodeList* res_ = gdome_doc_getElementsByTagName((GdomeDocument*) gdome_obj, tagname_, &exc_);
  
  if (tagname_ != 0) gdome_str_unref(tagname_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::getElementsByTagName");
  return NodeList(res_);
}

Node Document::importNode(const Node& importedNode, const bool deep) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_doc_importNode((GdomeDocument*) gdome_obj, (GdomeNode*) importedNode.gdome_object(), deep, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::importNode");
  return Node(res_);
}

Element Document::createElementNS(const DOMString& namespaceURI, const DOMString& qualifiedName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* qualifiedName_ = GdomeDOMString_of_DOMString(qualifiedName);
  GdomeElement* res_ = gdome_doc_createElementNS((GdomeDocument*) gdome_obj, namespaceURI_, qualifiedName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (qualifiedName_ != 0) gdome_str_unref(qualifiedName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createElementNS");
  return Element(res_);
}

Attr Document::createAttributeNS(const DOMString& namespaceURI, const DOMString& qualifiedName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* qualifiedName_ = GdomeDOMString_of_DOMString(qualifiedName);
  GdomeAttr* res_ = gdome_doc_createAttributeNS((GdomeDocument*) gdome_obj, namespaceURI_, qualifiedName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (qualifiedName_ != 0) gdome_str_unref(qualifiedName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::createAttributeNS");
  return Attr(res_);
}

NodeList Document::getElementsByTagNameNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeNodeList* res_ = gdome_doc_getElementsByTagNameNS((GdomeDocument*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::getElementsByTagNameNS");
  return NodeList(res_);
}

Element Document::getElementById(const DOMString& elementId) const
{
  GdomeException exc_;
  GdomeDOMString* elementId_ = GdomeDOMString_of_DOMString(elementId);
  GdomeElement* res_ = gdome_doc_getElementById((GdomeDocument*) gdome_obj, elementId_, &exc_);
  
  if (elementId_ != 0) gdome_str_unref(elementId_);
  
  if (exc_ != 0) throw DOMException(exc_, "Document::getElementById");
  return Element(res_);
}



}

