/*
search.h/search.cpp - Source Code for ElephantEye, Part VIII

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 3.15, Last Modified: Jul. 2008
Copyright (C) 2004-2008 www.elephantbase.net

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "base.h"
#include "rc4prng.h"
#include "ucci.h"
#include "pregen.h"
#include "position.h"

#ifndef SEARCH_H
#define SEARCH_H

#ifdef _WIN32
  #include <windows.h>
#else
  #define WINAPI
#endif

// ģʽ
const int GO_MODE_INFINITY = 0;
const int GO_MODE_NODES = 1;
const int GO_MODE_TIMER = 2;

// ǰõȫֱָ
struct SearchStruct {
  PositionStruct pos;                // дľ
  bool bQuit, bPonder, bDraw;        // Ƿյ˳ָ̨˼ģʽģʽ
  bool bBatch, bDebug;               // Ƿģʽ͵ģʽ
  bool bUseHash, bUseBook;           // ǷʹûüͿֿ
  bool bNullMove, bKnowledge;        // ǷŲüʹþ֪ʶ
  bool bAlwaysCheck;                 // Ƿֻ(ɱž)
  bool bIdle;                        // Ƿ
  RC4Struct rc4Random;               // 
  int nGoMode, nNodes, nCountMask;   // ģʽ
  int nProperTimer, nMaxTimer;       // ƻʹʱ
  int nRandomMask, nBanMoves;        // λͽ
  uint16_t wmvBanList[MAX_MOVE_NUM]; // б
  char szBookFile[1024];             // ֿ
  const char *(WINAPI *GetEngineName)(void);                     // APIָ
  void (WINAPI *PreEvaluate)(PositionStruct *, PreEvalStruct *); // ԤAPIָ
  int (WINAPI *Evaluate)(const PositionStruct *, int, int);      // APIָ
};

extern SearchStruct Search;

// UCCI湹
void BuildPos(PositionStruct &pos, const UcciCommStruct &UcciComm);

// UCCI֧ - ҶӽľϢ
void PopLeaf(PositionStruct &pos);

// 
void SearchMain(int nDepth);

#endif
