/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#undef GTK_DISABLE_DEPRECATED /* XXX */

#include "gtkvalueeditor.h"

#include <gtk/gtkentry.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkoptionmenu.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkspinbutton.h>

#include "glrr-gobject.h"

#include <stdlib.h>


enum {
  VALUE_CHANGED,
  LAST_SIGNAL
};


static void gtk_value_editor_class_init    (GtkValueEditorClass *klass);
static void gtk_value_editor_init	   (GtkValueEditor      *value_editor);
static void gtk_value_editor_finalize      (GObject             *object);
static void gtk_value_editor_value_changed (GtkValueEditor      *value_editor);

static void   num_make_widgets                  (GtkValueEditor  *value_editor);
static void   num_make_widgets_with_param_spec  (GtkValueEditor  *value_editor,
						 GParamSpec      *param_spec);
static void   num_update_widgets                (GtkValueEditor  *value_editor);
static void   num_set_value                     (GtkValueEditor  *value_editor,
						 GValue          *value);
static void   num_spin_button_value_changed     (GtkSpinButton   *spin_buton,
						 gpointer         user_data);
static gint   num_spin_button_input             (GtkSpinButton   *spin_buton,
						 gdouble         *new_val,
						 gpointer         user_data);
static gint   num_spin_button_output            (GtkSpinButton   *spin_buton,
						 gpointer         user_data);
static void   num_text_to_value                 (const gchar     *text,
						 GValue          *value);
static gchar* num_value_to_text                 (GValue          *value,
						 guint            digits);
static void   bool_make_widgets                 (GtkValueEditor  *value_editor);
static void   bool_make_widgets_with_param_spec (GtkValueEditor  *value_editor,
						 GParamSpec      *param_spec);
static void   bool_update_widgets               (GtkValueEditor  *value_editor);
static void   bool_set_value                    (GtkValueEditor  *value_editor,
						 GValue          *value);
static void   bool_toggle_button_toggled        (GtkToggleButton *toggle_button,
						 gpointer         user_data);
static void   enum_make_widgets                 (GtkValueEditor  *value_editor);
static void   enum_make_widgets_with_param_spec (GtkValueEditor  *value_editor,
						 GParamSpec      *param_spec);
static void   enum_update_widgets               (GtkValueEditor  *value_editor);
static void   enum_set_value                    (GtkValueEditor  *value_editor,
						 GValue          *value);
static void   enum_menu_item_activate           (GtkMenuItem     *menu_item,
						 gpointer         user_data);
static void   str_make_widgets                  (GtkValueEditor  *value_editor);
static void   str_make_widgets_with_param_spec  (GtkValueEditor  *value_editor,
						 GParamSpec      *param_spec);
static void   str_update_widgets                (GtkValueEditor  *value_editor);
static void   str_set_value                     (GtkValueEditor  *value_editor,
						 GValue          *value);
static void   str_editable_changed              (GtkEditable     *editable,
						 gpointer         user_data);


static GtkHBoxClass *parent_class = NULL;
static guint value_editor_signals[LAST_SIGNAL] = { 0 };


GType
gtk_value_editor_get_type (void)
{
  static GType value_editor_type = 0;

  if (!value_editor_type)
    {
      static const GTypeInfo value_editor_info =
      {
	sizeof (GtkValueEditorClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_value_editor_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkValueEditor),
	32,		/* n_preallocs */
	(GInstanceInitFunc) gtk_value_editor_init,
        NULL,           /* value_table */
      };

      value_editor_type
	= g_type_register_static (GTK_TYPE_HBOX,
				  "GtkValueEditor",
				  &value_editor_info, 0);
    }

  return value_editor_type;
}

static void
gtk_value_editor_class_init (GtkValueEditorClass *klass)
{
  GObjectClass   *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkHBoxClass *hbox_class;
  GtkValueEditorClass *value_editor_class;


  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  hbox_class = (GtkHBoxClass*) klass;
  value_editor_class = (GtkValueEditorClass*) klass;

  parent_class = g_type_class_peek_parent (klass);


  value_editor_signals[VALUE_CHANGED]
     = g_signal_new ("value_changed",
		     G_OBJECT_CLASS_TYPE (object_class),
		     G_SIGNAL_RUN_FIRST,
		     G_STRUCT_OFFSET (GtkValueEditorClass, value_changed),
		     NULL, NULL,
		     g_cclosure_marshal_VOID__VOID,
		     G_TYPE_NONE, 0);

  
  gobject_class->finalize = gtk_value_editor_finalize;
  value_editor_class->value_changed = gtk_value_editor_value_changed;
}

static void
gtk_value_editor_init (GtkValueEditor *value_editor)
{
  value_editor->widget_list = NULL;

  g_value_fill0 (&(value_editor->value));
  value_editor->value_type = 0;
}

static void
gtk_value_editor_finalize (GObject *object)
{
  GtkValueEditor *value_editor;

  value_editor = GTK_VALUE_EDITOR (object);


  g_value_unset (&(value_editor->value));


  if (value_editor->widget_list)
    {
      g_list_free (value_editor->widget_list);
      value_editor->widget_list = NULL;
    }


  (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

GtkWidget*
gtk_value_editor_new (GType type)
{
  GtkValueEditor *value_editor;
  GValue         *value;


  value_editor = g_object_new (GTK_TYPE_VALUE_EDITOR, NULL);


  value = gtk_value_editor_get_value (value_editor);
  g_value_init (value, type);

  value_editor->value_type = type;

  switch (G_TYPE_FUNDAMENTAL (type))
    {
    case G_TYPE_CHAR:
    case G_TYPE_UCHAR:
    case G_TYPE_INT:
    case G_TYPE_UINT:
    case G_TYPE_LONG:
    case G_TYPE_ULONG:
    case G_TYPE_INT64:
    case G_TYPE_UINT64:
    case G_TYPE_FLOAT:
    case G_TYPE_DOUBLE:
      num_make_widgets (value_editor);
      break;

    case G_TYPE_BOOLEAN:
      bool_make_widgets (value_editor);
      break;

    case G_TYPE_ENUM:
      enum_make_widgets (value_editor);
      break;

    case G_TYPE_STRING:
      str_make_widgets (value_editor);
      break;

    default:
      break;
    }

  return GTK_WIDGET (value_editor);
}

GtkWidget*
gtk_value_editor_new_with_param_spec (GParamSpec *param_spec)
{
  GtkValueEditor *value_editor;
  GValue         *value;
  GType           param_spec_type;


  value_editor = g_object_new (GTK_TYPE_VALUE_EDITOR, NULL);


  value = gtk_value_editor_get_value (value_editor);
  g_value_init (value, param_spec->value_type);

  value_editor->value_type = param_spec->value_type;


  param_spec_type = G_PARAM_SPEC_TYPE (param_spec);

  if (0)
    {
    }
  else if ((param_spec_type == G_TYPE_PARAM_CHAR)   ||
	   (param_spec_type == G_TYPE_PARAM_UCHAR)  ||
	   (param_spec_type == G_TYPE_PARAM_INT)    ||
	   (param_spec_type == G_TYPE_PARAM_UINT)   ||
	   (param_spec_type == G_TYPE_PARAM_LONG)   ||
	   (param_spec_type == G_TYPE_PARAM_ULONG)  ||
	   (param_spec_type == G_TYPE_PARAM_INT64)  ||
	   (param_spec_type == G_TYPE_PARAM_UINT64) ||
	   (param_spec_type == G_TYPE_PARAM_FLOAT)  ||
	   (param_spec_type == G_TYPE_PARAM_DOUBLE))
    {
      num_make_widgets_with_param_spec (value_editor, param_spec);
    }
  else if (param_spec_type == G_TYPE_PARAM_BOOLEAN)
    {
      bool_make_widgets_with_param_spec (value_editor, param_spec);
    }
  else if (param_spec_type == G_TYPE_PARAM_ENUM)
    {
      enum_make_widgets_with_param_spec (value_editor, param_spec);
    }
  else if (param_spec_type == G_TYPE_PARAM_STRING)
    {
      str_make_widgets_with_param_spec (value_editor, param_spec);
    }
  else
    {
      /***/
    }


  return GTK_WIDGET (value_editor);
}


static void
gtk_value_editor_value_changed (GtkValueEditor *value_editor)
{
}



GType
gtk_value_editor_get_value_type (GtkValueEditor *value_editor)
{
  GType type;

  g_return_val_if_fail (value_editor != NULL, G_TYPE_INVALID);
  g_return_val_if_fail (GTK_IS_VALUE_EDITOR (value_editor), G_TYPE_INVALID);


  type = value_editor->value_type;


  return type;
}

GValue *
gtk_value_editor_get_value (GtkValueEditor *value_editor)
{
  GValue *value;

  
  g_return_val_if_fail (value_editor != NULL, NULL);
  g_return_val_if_fail (GTK_IS_VALUE_EDITOR (value_editor), NULL);


  value = &(value_editor->value);


  return value;
}

void
gtk_value_editor_set_value (GtkValueEditor *value_editor,
			    GValue         *value)
{
  g_return_if_fail (value_editor != NULL);
  g_return_if_fail (GTK_IS_VALUE_EDITOR (value_editor));
  g_return_if_fail (value != NULL);


  switch (G_TYPE_FUNDAMENTAL (G_VALUE_TYPE (value)))
    {
    case G_TYPE_CHAR:
    case G_TYPE_UCHAR:
    case G_TYPE_INT:
    case G_TYPE_UINT:
    case G_TYPE_LONG:
    case G_TYPE_ULONG:
    case G_TYPE_INT64:
    case G_TYPE_UINT64:
    case G_TYPE_FLOAT:
    case G_TYPE_DOUBLE:
      num_set_value (value_editor, value);
      num_update_widgets (value_editor);
      break;

    case G_TYPE_BOOLEAN:
      bool_set_value (value_editor, value);
      bool_update_widgets (value_editor);
      break;

    case G_TYPE_ENUM:
      enum_set_value (value_editor, value);
      enum_update_widgets (value_editor);
      break;

    case G_TYPE_STRING:
      str_set_value (value_editor, value);
      str_update_widgets (value_editor);
      break;

    default:
      break;
    }
}



/*****/
static void
num_make_widgets  (GtkValueEditor *value_editor)
{
  num_make_widgets_with_param_spec (value_editor,
				    NULL);
}

static void
num_make_widgets_with_param_spec (GtkValueEditor *value_editor,
				  GParamSpec     *param_spec)
{
  GType param_spec_type;

  GtkAdjustment *adjustment;
  GtkWidget *spin_button;

  gdouble value;
  gdouble lower;
  gdouble upper;
  gdouble step_increment;
  gdouble page_increment;
  gdouble page_size;

  gdouble climb_rate;
  guint   digits;


  if (param_spec != NULL)
    {
      param_spec_type = G_PARAM_SPEC_TYPE (param_spec);

      if (0)
	{
	}
      else if (param_spec_type == G_TYPE_PARAM_CHAR)
	{
	  value = G_PARAM_SPEC_CHAR (param_spec)->default_value;
	  lower = G_PARAM_SPEC_CHAR (param_spec)->minimum;
	  upper = G_PARAM_SPEC_CHAR (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_UCHAR)
	{
	  value = G_PARAM_SPEC_UCHAR (param_spec)->default_value;
	  lower = G_PARAM_SPEC_UCHAR (param_spec)->minimum;
	  upper = G_PARAM_SPEC_UCHAR (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_INT)
	{
	  value = G_PARAM_SPEC_INT (param_spec)->default_value;
	  lower = G_PARAM_SPEC_INT (param_spec)->minimum;
	  upper = G_PARAM_SPEC_INT (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_UINT)
	{
	  value = G_PARAM_SPEC_UINT (param_spec)->default_value;
	  lower = G_PARAM_SPEC_UINT (param_spec)->minimum;
	  upper = G_PARAM_SPEC_UINT (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_LONG)
	{
	  value = G_PARAM_SPEC_LONG (param_spec)->default_value;
	  lower = G_PARAM_SPEC_LONG (param_spec)->minimum;
	  upper = G_PARAM_SPEC_LONG (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_ULONG)
	{
	  value = G_PARAM_SPEC_ULONG (param_spec)->default_value;
	  lower = G_PARAM_SPEC_ULONG (param_spec)->minimum;
	  upper = G_PARAM_SPEC_ULONG (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_INT64)
	{
	  value = G_PARAM_SPEC_INT64 (param_spec)->default_value;
	  lower = G_PARAM_SPEC_INT64 (param_spec)->minimum;
	  upper = G_PARAM_SPEC_INT64 (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_UINT64)
	{
	  value = G_PARAM_SPEC_UINT64 (param_spec)->default_value;
	  lower = G_PARAM_SPEC_UINT64 (param_spec)->minimum;
	  upper = G_PARAM_SPEC_UINT64 (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_FLOAT)
	{
	  value = G_PARAM_SPEC_FLOAT (param_spec)->default_value;
	  lower = G_PARAM_SPEC_FLOAT (param_spec)->minimum;
	  upper = G_PARAM_SPEC_FLOAT (param_spec)->maximum;
	}
      else if (param_spec_type == G_TYPE_PARAM_DOUBLE)
	{
	  value = G_PARAM_SPEC_DOUBLE (param_spec)->default_value;
	  lower = G_PARAM_SPEC_DOUBLE (param_spec)->minimum;
	  upper = G_PARAM_SPEC_DOUBLE (param_spec)->maximum;
	}
      else
	{
	  g_assert_not_reached ();
	}
    }
  else /* if (param_spec == NULL) */
    {
      switch (value_editor->value_type)
	{
	case G_TYPE_CHAR:
	  value = 0;
	  lower = -127;	/* XXX */
	  upper = 128;	/* XXX */
	  break;

	case G_TYPE_UCHAR:
	  value = 0;
	  lower = 0;	/* XXX */
	  upper = 255;	/* XXX */
	  break;

	case G_TYPE_INT:
	  value = 0;
	  lower = G_MININT;
	  upper = G_MAXINT;
	  break;

	case G_TYPE_UINT:
	  value = 0;
	  lower = 0;
	  upper = G_MAXUINT;
	  break;

	case G_TYPE_LONG:
	  value = 0;
	  lower = G_MINLONG;
	  upper = G_MAXLONG;
	  break;

	case G_TYPE_ULONG:
	  value = 0;
	  lower = 0;
	  upper = G_MAXULONG;
	  break;

	case G_TYPE_INT64:
	  value = 0;
	  lower = G_MININT64;
	  upper = G_MAXINT64;
	  break;

	case G_TYPE_UINT64:
	  value = 0;
	  lower = 0;
	  upper = G_MAXUINT64;
	  break;

	case G_TYPE_FLOAT:
	  value = 0.0;
	  lower = G_MINFLOAT;
	  upper = G_MAXFLOAT;
	  break;

	case G_TYPE_DOUBLE:
	  value = 0.0;
	  lower = G_MINDOUBLE;
	  upper = G_MAXDOUBLE;
	  break;

	default:
	  g_assert_not_reached ();
	  break;
	}
    }

  switch (G_TYPE_FUNDAMENTAL (value_editor->value_type))
    {
    case G_TYPE_CHAR:
    case G_TYPE_UCHAR:
    case G_TYPE_INT:
    case G_TYPE_UINT:
    case G_TYPE_LONG:
    case G_TYPE_ULONG:
    case G_TYPE_INT64:
    case G_TYPE_UINT64:
      {
	step_increment = 1.0;
	page_increment = MAX (((upper - lower) / 16), 1.0);
	page_size      = 0.0;
	climb_rate     = 1.0;
	digits         = 0;
      }
      break;

    case G_TYPE_FLOAT:
    case G_TYPE_DOUBLE:
      {
	step_increment = 0.05;
	page_increment = MAX (((upper - lower) / 16), 0.05);
	page_size      = 0.0;
	climb_rate     = 0.05;
	digits         = 4;
      }
      break;

    default:
      {
	g_assert_not_reached ();
      }
      break;
    }

  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new (value,
						   lower,
						   upper,
						   step_increment,
						   page_increment,
						   page_size));

  spin_button = gtk_spin_button_new (adjustment, climb_rate, digits);
  gtk_box_pack_start (GTK_BOX (value_editor),
		      spin_button,
		      FALSE, FALSE, 0);

  value_editor->widget_list
    = g_list_append (value_editor->widget_list,
		     spin_button);

  g_signal_connect (spin_button,
		    "value_changed",
		    G_CALLBACK (num_spin_button_value_changed), value_editor);
  g_signal_connect (spin_button,
		    "input",
		    G_CALLBACK (num_spin_button_input), value_editor);
  g_signal_connect (spin_button,
		    "output",
		    G_CALLBACK (num_spin_button_output), value_editor);
}

static void
num_update_widgets (GtkValueEditor *value_editor)
{
  GValue *value;
  GtkSpinButton *spin_button;
  gdouble v;


  value = gtk_value_editor_get_value (value_editor);

  {
    GValue tmp;

    g_value_fill0 (&tmp);

    g_value_init (&tmp, G_TYPE_DOUBLE);

    g_value_transform (value, &tmp);

    v = g_value_get_double (&tmp);

    g_value_unset (&tmp);
  }

  spin_button = GTK_SPIN_BUTTON (g_list_first (value_editor->widget_list)->data);

  gtk_spin_button_set_value (spin_button, v);
}

static void
num_set_value (GtkValueEditor *value_editor,
	       GValue         *value)
{
  GType   val_type;
  GValue *val;


  val_type = gtk_value_editor_get_value_type (value_editor);
  val      = gtk_value_editor_get_value (value_editor);

  g_value_reset (val);
  g_value_copy (value, val);
}

static void
num_spin_button_value_changed (GtkSpinButton *spin_button,
			       gpointer       user_data)
{
  GtkValueEditor *value_editor;
  GValue *value;


  value_editor = GTK_VALUE_EDITOR (user_data);
  value = gtk_value_editor_get_value (value_editor);

  {
    GValue tmp;

    g_value_fill0 (&tmp);

    g_value_init (&tmp, G_TYPE_DOUBLE);

    g_value_set_double (&tmp, spin_button->adjustment->value);
    
    g_value_transform (&tmp, value);

    g_value_unset (&tmp);
  }

  g_signal_emit (value_editor, value_editor_signals[VALUE_CHANGED], 0);
}

static gint
num_spin_button_input (GtkSpinButton *spin_button,
		       gdouble       *new_val,
		       gpointer       user_data)
{
  GtkValueEditor *value_editor;
  GValue *value;


  value_editor = GTK_VALUE_EDITOR (user_data);
  value = gtk_value_editor_get_value (value_editor);

  {
    GValue tmp1;
    GValue tmp2;
    const gchar *text;

    g_value_fill0 (&tmp1);
    g_value_fill0 (&tmp2);

    g_value_init (&tmp1, value_editor->value_type);
    g_value_init (&tmp2, G_TYPE_DOUBLE);

    text = gtk_entry_get_text (GTK_ENTRY (spin_button));

    num_text_to_value (text, &tmp1);
    g_value_transform (&tmp1, &tmp2);
    
    *new_val = g_value_get_double (&tmp2);

    g_value_unset (&tmp1);
    g_value_unset (&tmp2);
  }


  return TRUE;
}

static gint
num_spin_button_output (GtkSpinButton *spin_button,
			gpointer       user_data)
{
  GtkValueEditor *value_editor;
  const gchar *text;
  gdouble v1;
  gdouble v2;


  value_editor = GTK_VALUE_EDITOR (user_data);

  text = gtk_entry_get_text (GTK_ENTRY (spin_button));


  {
    GValue tmp1;
    GValue tmp2;

    g_value_fill0 (&tmp1);
    g_value_fill0 (&tmp2);

    g_value_init (&tmp1, value_editor->value_type);
    g_value_init (&tmp2, G_TYPE_DOUBLE);

    num_text_to_value (text, &tmp1);
    g_value_transform (&tmp1, &tmp2);

    v1 = g_value_get_double (&tmp2);

    g_value_unset (&tmp1);
    g_value_unset (&tmp2);
  }

  {
    v2 = spin_button->adjustment->value;
  }


  if (v1 != v2)
    {
      gchar *tmp_text;

      {
	GValue tmp1;
	GValue tmp2;

	g_value_fill0 (&tmp1);
	g_value_fill0 (&tmp2);

	g_value_init (&tmp1, G_TYPE_DOUBLE);
	g_value_init (&tmp2, value_editor->value_type);

	g_value_set_double (&tmp1, spin_button->adjustment->value);
	g_value_transform (&tmp1, &tmp2);

	tmp_text = num_value_to_text (&tmp2, spin_button->digits);

	g_value_unset (&tmp1);
	g_value_unset (&tmp2);
      }

      gtk_entry_set_text (GTK_ENTRY (spin_button), tmp_text);

      if (tmp_text != NULL)
	{
	  g_free (tmp_text);
	}
    }

  return TRUE;
}

static void
num_text_to_value (const gchar *text,
		   GValue      *value)
{
  g_value_reset (value);

  switch (G_TYPE_FUNDAMENTAL (G_VALUE_TYPE (value)))
    {
    case G_TYPE_CHAR:
      g_value_set_char   (value, strtol (text, NULL, 0));
      break;

    case G_TYPE_UCHAR:
      g_value_set_uchar  (value, strtoul (text, NULL, 0));
      break;

    case G_TYPE_INT:
      g_value_set_int    (value, strtol (text, NULL, 0));
      break;

    case G_TYPE_UINT:
      g_value_set_uint   (value, strtoul (text, NULL, 0));
      break;

    case G_TYPE_LONG:
      g_value_set_long   (value, strtol (text, NULL, 0));
      break;

    case G_TYPE_ULONG:
      g_value_set_ulong  (value, strtoul (text, NULL, 0));
      break;

    case G_TYPE_INT64:
      g_value_set_int64  (value, strtoll (text, NULL, 0));
      break;

    case G_TYPE_UINT64:
      g_value_set_uint64 (value, strtoull (text, NULL, 0));
      break;


    case G_TYPE_FLOAT:
      g_value_set_float  (value, g_strtod (text, NULL));
      break;

    case G_TYPE_DOUBLE:
      g_value_set_double (value, g_strtod (text, NULL));
      break;


    default:
      g_assert_not_reached();
    }
}

static gchar*
num_value_to_text (GValue *value,
		   guint   digits)
{
  gchar *text;

  switch (G_TYPE_FUNDAMENTAL (G_VALUE_TYPE (value)))
    {
    case G_TYPE_CHAR:
      text = g_strdup_printf ("%d",   g_value_get_char (value));
      break;

    case G_TYPE_UCHAR:
      text = g_strdup_printf ("%d",   g_value_get_uchar (value));
      break;

    case G_TYPE_INT:
      text = g_strdup_printf ("%d",   g_value_get_int (value));
      break;

    case G_TYPE_UINT:
      text = g_strdup_printf ("%d",   g_value_get_uint (value));
      break;

    case G_TYPE_LONG:
      text = g_strdup_printf ("%ld",  g_value_get_long (value));
      break;

    case G_TYPE_ULONG:
      text = g_strdup_printf ("%ld",  g_value_get_ulong (value));
      break;

    case G_TYPE_INT64:
      text = g_strdup_printf ("%lld", g_value_get_int64 (value));
      break;

    case G_TYPE_UINT64:
      text = g_strdup_printf ("%lld", g_value_get_uint64 (value));
      break;


    case G_TYPE_FLOAT:
      text = g_strdup_printf ("%0.*f", (int)digits, g_value_get_float (value));
      break;

    case G_TYPE_DOUBLE:
      text = g_strdup_printf ("%0.*f", (int)digits, g_value_get_double (value));
      break;


    default:
      g_assert_not_reached();

      text = NULL;
      break;
    }


  return text;
}


/*****/
static void
bool_make_widgets  (GtkValueEditor *value_editor)
{
  bool_make_widgets_with_param_spec (value_editor, NULL);
}

static void
bool_make_widgets_with_param_spec (GtkValueEditor *value_editor,
				   GParamSpec     *param_spec)
{
  GtkWidget *toggle_button;
  GtkWidget *label;

  toggle_button = gtk_toggle_button_new ();
  gtk_box_pack_start (GTK_BOX (value_editor), toggle_button,
		      FALSE, FALSE, 0);

  label = gtk_label_new (NULL);
  gtk_container_add (GTK_CONTAINER (toggle_button), label);

  value_editor->widget_list
    = g_list_append (value_editor->widget_list,
		     toggle_button);


  if (param_spec != NULL)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_button),
				    G_PARAM_SPEC_BOOLEAN (param_spec)->default_value);
    }

  g_signal_connect (G_OBJECT (toggle_button),
		    "toggled",
		    G_CALLBACK (bool_toggle_button_toggled), value_editor);

  gtk_toggle_button_toggled (GTK_TOGGLE_BUTTON (toggle_button));
}

static void
bool_update_widgets (GtkValueEditor *value_editor)
{
  GValue *value;
  GtkToggleButton *toggle_button;


  value = gtk_value_editor_get_value (value_editor);


  toggle_button = GTK_TOGGLE_BUTTON
			(g_list_first (value_editor->widget_list)->data);

  gtk_toggle_button_set_active (toggle_button,
				g_value_get_boolean (value));
}

static void
bool_set_value (GtkValueEditor *value_editor,
		GValue         *value)
{
  GType   val_type;
  GValue *val;


  val_type = gtk_value_editor_get_value_type (value_editor);
  val      = gtk_value_editor_get_value (value_editor);

  g_value_reset (val);
  g_value_copy (value, val);
}

static void
bool_toggle_button_toggled (GtkToggleButton *toggle_button,
			    gpointer         user_data)
{
  GtkValueEditor *value_editor;
  GValue *value;


  value_editor = GTK_VALUE_EDITOR (user_data);
  value = gtk_value_editor_get_value (value_editor);


  g_value_set_boolean (value,
		       gtk_toggle_button_get_active (toggle_button));


  gtk_label_set_text (GTK_LABEL (GTK_BIN (toggle_button)->child),
		      (gtk_toggle_button_get_active (toggle_button)
		       ? "true"
		       : "false"));


  g_signal_emit (value_editor, value_editor_signals[VALUE_CHANGED], 0);
}


/*****/
static void
enum_make_widgets (GtkValueEditor *value_editor)
{
  enum_make_widgets_with_param_spec (value_editor, NULL);
}

static void
enum_make_widgets_with_param_spec (GtkValueEditor *value_editor,
				   GParamSpec     *param_spec)
{
  GtkWidget *option_menu;
  GtkWidget *menu;
  GtkWidget *menu_item;

  GEnumClass *enum_class;
  guint n;


  option_menu = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (value_editor), option_menu,
		      FALSE, FALSE, 0);

  menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);


  value_editor->widget_list
    = g_list_append (value_editor->widget_list, option_menu);


  enum_class = G_ENUM_CLASS (g_type_class_ref (value_editor->value_type));

  for (n = 0; n < enum_class->n_values; ++n)
    {
      menu_item	= gtk_menu_item_new_with_label
			(enum_class->values[n].value_nick);

      g_object_set_data (G_OBJECT (menu_item),
			 "gtk-value-editor-enum-value",
			 GINT_TO_POINTER (n));

      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);

      g_signal_connect (menu_item,
			"activate",
			G_CALLBACK (enum_menu_item_activate), value_editor);
    }

  g_type_class_unref (enum_class);


  if (param_spec != NULL)
    {
      gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu),
				   G_PARAM_SPEC_ENUM (param_spec)->default_value);
    }
  else
    {
      gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu),
				   0);
    }
}

static void
enum_update_widgets (GtkValueEditor *value_editor)
{
  GValue *value;

  GEnumClass *enum_class;
  int n;
  guint i;


  value = gtk_value_editor_get_value (value_editor);

  enum_class = G_ENUM_CLASS (g_type_class_ref (value_editor->value_type));

  n = -1;
  for (i = 0; i < enum_class->n_values; ++i)
    {
      if (g_value_get_enum (value) == enum_class->values[i].value)
	{
	  n = i;
	  break;
	}
    }

  if (n >= 0)
    {
      GtkOptionMenu *option_menu;

      option_menu = GTK_OPTION_MENU ((value_editor->widget_list)->data);

      gtk_option_menu_set_history (option_menu, n);
    }


  g_type_class_unref (enum_class);
}

static void
enum_set_value (GtkValueEditor *value_editor,
		GValue         *value)
{
  GType   val_type;
  GValue *val;


  val_type = gtk_value_editor_get_value_type (value_editor);
  val      = gtk_value_editor_get_value (value_editor);

  g_value_reset (val);
  g_value_copy (value, val);
}

static void
enum_menu_item_activate (GtkMenuItem *menu_item,
			 gpointer     user_data)
{
  GtkValueEditor *value_editor;
  GValue *value;

  GEnumClass *enum_class;
  int n;


  value_editor = GTK_VALUE_EDITOR (user_data);
  value = gtk_value_editor_get_value (value_editor);

  enum_class = G_ENUM_CLASS (g_type_class_ref (value_editor->value_type));

  n = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (menu_item),
					  "gtk-value-editor-enum-value"));
  g_value_set_enum (value, enum_class->values[n].value);

  g_type_class_unref (enum_class);


  g_signal_emit (value_editor, value_editor_signals[VALUE_CHANGED], 0);
}


/*****/
static void
str_make_widgets  (GtkValueEditor *value_editor)
{
  str_make_widgets_with_param_spec (value_editor, NULL);
}

static void
str_make_widgets_with_param_spec (GtkValueEditor *value_editor,
				  GParamSpec     *param_spec)
{
  GtkWidget *entry;

  entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (value_editor), entry,
		      FALSE, FALSE, 0);

  value_editor->widget_list
    = g_list_append (value_editor->widget_list,
		     entry);

  if (param_spec != NULL)
    {
      gchar *text;

      text = G_PARAM_SPEC_STRING (param_spec)->default_value;

      if (text != NULL)
	{
	  gtk_entry_set_text (GTK_ENTRY (entry), text);
	}
    }

  g_signal_connect (G_OBJECT (entry),
		    "changed",
		    G_CALLBACK (str_editable_changed), value_editor);
}

static void
str_update_widgets (GtkValueEditor *value_editor)
{
  GValue *value;
  GtkEntry *entry;
  const gchar *text;


  value = gtk_value_editor_get_value (value_editor);

  entry = GTK_ENTRY (g_list_first (value_editor->widget_list)->data);
  text = g_value_get_string (value);

  if (text != NULL)
    {
      gtk_entry_set_text (entry, text);
    }
  else
    {
      gtk_entry_set_text (entry, "");
    }
}

static void
str_set_value (GtkValueEditor *value_editor,
	       GValue         *value)
{
  GType   val_type;
  GValue *val;


  val_type = gtk_value_editor_get_value_type (value_editor);
  val      = gtk_value_editor_get_value (value_editor);

  g_value_reset (val);
  g_value_copy (value, val);
}

static void
str_editable_changed (GtkEditable *editable,
		      gpointer     user_data)
{
  GtkValueEditor *value_editor;
  GValue *value;
  const gchar *text;


  value_editor = GTK_VALUE_EDITOR (user_data);
  value = gtk_value_editor_get_value (value_editor);


  text = gtk_entry_get_text (GTK_ENTRY (editable));


  g_value_set_string (value, text);


  g_signal_emit (value_editor, value_editor_signals[VALUE_CHANGED], 0);
}
