/*  Glimmer - open-remote-file.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include "widgets/gnome-vfs-remote-dialog.h"
#include "open-remote-file.h"
#include "dialogs.h"
#include "file-io.h"
#include "main.h"
#include "misc.h"
#include "settings.h"

static void open_remote_file_ok_cb(GtkWidget *widget, GnomeVFSRemoteDialog *dialog);
static void open_remote_file_cancel_cb(GtkWidget *widget, GnomeVFSRemoteDialog *dialog);

void open_remote_file_cb(GtkWidget *widget, gpointer data)
{
   static GtkWidget *remote_selector;
   if(!remote_selector)
   {
      remote_selector = gnome_vfs_remote_dialog_new("Open Remote File...", build_glist_from_file("remote-open.hist", general_preferences.history));
      gtk_signal_connect(GTK_OBJECT(GNOME_VFS_REMOTE_DIALOG(remote_selector)->ok_button), "clicked", GTK_SIGNAL_FUNC(open_remote_file_ok_cb), remote_selector);
      gtk_signal_connect(GTK_OBJECT(GNOME_VFS_REMOTE_DIALOG(remote_selector)->cancel_button), "clicked", GTK_SIGNAL_FUNC(open_remote_file_cancel_cb), remote_selector);
      gtk_window_set_transient_for(GTK_WINDOW(remote_selector), GTK_WINDOW(window));
      gtk_widget_show(remote_selector);
      gtk_widget_grab_focus(GNOME_VFS_REMOTE_DIALOG(remote_selector)->path_entry);
   }
   else
   {
      gtk_entry_set_text(GTK_ENTRY(GNOME_VFS_REMOTE_DIALOG(remote_selector)->host_entry), "");
      gtk_entry_set_text(GTK_ENTRY(GNOME_VFS_REMOTE_DIALOG(remote_selector)->port_entry), "");
      gtk_entry_set_text(GTK_ENTRY(GNOME_VFS_REMOTE_DIALOG(remote_selector)->path_entry), "");
      gtk_entry_set_text(GTK_ENTRY(GNOME_VFS_REMOTE_DIALOG(remote_selector)->username_entry), "");
      gtk_entry_set_text(GTK_ENTRY(GNOME_VFS_REMOTE_DIALOG(remote_selector)->password_entry), "");
      gtk_option_menu_set_history(GTK_OPTION_MENU(GNOME_VFS_REMOTE_DIALOG(remote_selector)->history), 0);
      gtk_widget_show(remote_selector);
      gtk_widget_grab_focus(GNOME_VFS_REMOTE_DIALOG(remote_selector)->path_entry);
   }
}

static void open_remote_file_ok_cb(GtkWidget *widget, GnomeVFSRemoteDialog *dialog)
{
   GnomeVFSURI *uri = NULL;
   gchar *full_uri = NULL;
   gchar *save_uri = NULL;
   GdsFile *last = cur_file;
   gboolean save_pass;

   gtk_widget_hide(GTK_WIDGET(dialog));
   uri = gnome_vfs_remote_dialog_get_uri(dialog);
   if(uri)
   {
      save_pass = gnome_vfs_remote_dialog_save_pass(dialog);
      full_uri = gnome_vfs_uri_to_string(uri, GNOME_VFS_URI_HIDE_NONE);
      open_file_real(full_uri);
      if(cur_file != last)
      {
         gchar *password;
         password = (gchar *)gnome_vfs_uri_get_password(uri);
         if(password) cur_file->need_pass = TRUE;
         if(!save_pass) gnome_vfs_uri_set_password(cur_file->uri, NULL);
         save_uri = gnome_vfs_uri_to_string(uri, save_pass ? GNOME_VFS_URI_HIDE_NONE : GNOME_VFS_URI_HIDE_PASSWORD);
         if(gnome_vfs_remote_dialog_add_history_string(dialog, save_uri))
            add_string_to_file("remote-open.hist", save_uri);
         g_free(save_uri);
      }
      gnome_vfs_uri_unref(uri);
      g_free(full_uri);
   }
   else
   {
      if(!bad_uri_data_dialog(NULL))
         gtk_widget_show(GTK_WIDGET(dialog));
   }
}
static void open_remote_file_cancel_cb(GtkWidget *widget, GnomeVFSRemoteDialog *dialog)
{
   gtk_widget_hide(GTK_WIDGET(dialog));
}
