/*
  Glaurung, a UCI chess playing engine.
  Copyright (C) 2004-2007 Tord Romstad

  Glaurung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  Glaurung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#if !defined(DISTANCE_H_INCLUDED)
#define DISTANCE_H_INCLUDED

////
//// Includes
////

#include "misc.h"
#include "square.h"


////
//// Types
////

enum Distance {
  DISTANCE_MIN = 0,
  DISTANCE_MAX = 7
};


////
//// Inline functions
////

inline Distance operator+ (Distance d1, Distance d2) {
  return Distance(int(d1) + int(d2));
}

inline Distance operator- (Distance d1, Distance d2) {
  return Distance(int(d1) - int(d2));
}

inline Distance file_distance(File f1, File f2) {
  return Distance(abs(int(f1) - int(f2)));
}

inline Distance file_distance(Square s1, Square s2) {
  return file_distance(square_file(s1), square_file(s2));
}

inline Distance rank_distance(Rank r1, Rank r2) {
  return Distance(abs(int(r1) - int(r2)));
}

inline Distance rank_distance(Square s1, Square s2) {
  return rank_distance(square_rank(s1), square_rank(s2));
}

inline Distance square_distance(Square s1, Square s2) {
  return Max(file_distance(s1, s2), rank_distance(s1, s2));
}


#endif // !defined(DISTANCE_H_INCLUDED)
