// $Id: list.cc,v 1.24 2002/07/18 16:06:31 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_List : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_List();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void ApplyPreferences(Tag &t) const;
};

static Gtk_List Gtk_List;

const std::string Gtk_List::TypeName(const Widget &w) const
{  return GtkPrefix()+"List";
}

const std::string Gtk_List::IncludeName(const Widget &w) const
{  if (GTKMM2) return Configuration.GtkmmIncludePath()+"container.h";
   return Configuration.GtkmmIncludePath()+"list.h";
}

Gtk_List::Gtk_List()
{  Writer["GtkList"]=this;
}

void Gtk_List::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "selection_mode");
}

void Gtk_List::ApplyPreferences(Tag &t) const
{  if (GTKMM2) static_cast<GladeTag*>(&t)->setWidgetType("GtkTreeView");
   Parent::ApplyPreferences(t);
}
