// $Id: text.cc,v 1.28 2002/06/15 13:22:14 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "editable.hh"

class Gtk_Text : public Gtk_Editable
{public:
	typedef Gtk_Editable Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Text();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
	virtual void ApplyPreferences(Tag &t) const;
};

static Gtk_Text Gtk_Text;

const std::string Gtk_Text::TypeName(const Widget &w) const
{  return GtkPrefix()+"Text";
}

const std::string Gtk_Text::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"text.h";
}

Gtk_Text::Gtk_Text()
{  Writer["GtkText"]=this;
}

void Gtk_Text::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteBoolProperty(w,f,instance, "editable");
   WriteBoolProperty(w,f,instance, "word_wrap");
   WriteIntProperty(w,f,instance, "point");
   std::string text(w.getProperty("text"));
   if (!text.empty())
   {  f.StartBlock().Declaration("gint _dummy(0)");
      f.Statement() << instance << "insert_text(" 
      	<< Configuration.Translatable(text) 
      	<< ", ";
      if (!Configuration.gettext_support) f << text.size();
      else f << "strlen(" << Configuration.Translatable(text) << ')';
      f << ", &_dummy)";
      f.EndBlock().EndLine();
   }
}

const std::string Gtk_Text::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const
{  scope=Gtk_Text::TypeName(w);
   if (signal=="set_scroll_adjustments")
      return "GtkAdjustment *p0, GtkAdjustment *p1";
   return Parent::SignalHandlerArgs(w,signal,rettype,scope);
}

void Gtk_Text::ApplyPreferences(Tag &t) const
{  if (GTKMM2)
   {  static_cast<GladeTag*>(&t)->setWidgetType("GtkTextView");
      Widget w(&t);
      LookupWriter(w).ApplyPreferences(t);
   }
   else
      Parent::ApplyPreferences(t);
}

