// $Id: toolbar.cc,v 1.48 2001/10/22 06:20:38 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Toolbar : public Gtk_Container
{	bool isXPM(const std::string &file) const;
public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Toolbar();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
//	virtual bool CantMemberConstruct(const Widget &w) const
//	{  return true; }
	virtual void AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const;
	virtual void CreatePointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
	virtual Subwidget IsSubwidget(const Widget &w,const Widget &ch) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual const std::string Instance(const Widget &parent,const Widget &w2,Subwidget sw=SW_Unknown) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
};

static Gtk_Toolbar Gtk_Toolbar;

const std::string Gtk_Toolbar::TypeName(const Widget &w) const
{  return GtkPrefix()+"Toolbar";
}

const std::string Gtk_Toolbar::IncludeName(const Widget &w) const
{  return "gtk--/toolbar.h";
}

Gtk_Toolbar::Gtk_Toolbar()
{  Writer["GtkToolbar"]=this;
}

void Gtk_Toolbar::ConstructionArgs(const Widget &w, CxxFile &f) const
{  std::string orientation=w.getString("orientation","GTK_ORIENTATION_HORIZONTAL");
   std::string style=w.getString("type","GTK_TOOLBAR_BOTH");
   
   f.FunctionArg() << orientation;
   f.FunctionArg() << style;
}

 // toolbar.tools.push_back(WidgetElem(widget[,tooltip_text,private_text]));
void Gtk_Toolbar::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{
#if 0
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {const Widget w2(*i);
       const std::string clss(w2.Class());
       if (IsSubwidget(w,*i)==not_Subwidget || (clss!="GtkButton" 
       			&& clss!="GtkToggleButton" && clss!="GtkRadioButton"))
       {f.Statement() << instance << "tools().push_back(Gtk::Toolbar_Helpers::WidgetElem("
       		<< Reference(w2) << "))";
       	// tooltip_text?
       }        
      }
   }
#endif   
}

void Gtk_Toolbar::CreatePointer_Toplevel(const Widget &w,CxxFile &f) const
{  Parent::CreatePointer_Toplevel(w,f);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {const Widget w2(*i);
       if (IsSubwidget(w,*i)!=not_Subwidget && ((*i).ChildName()=="Toolbar:button"))
       { const std::string label(w2.getString("label"));
         const std::string stock_pixmap(w2.getString("stock_pixmap"));
         const std::string icon(w2.getString("icon"));
         
	// we can't use C++ because we don't want to connect right now
	// and what about the new calling style?
	
	// GTK_TOOLBAR_CHILD_WIDGET
	
	 const WriterBase &wr2(LookupWriter(w2));
	 std::string gtk_macro(wr2.GtkCast(w2)),
	 	toolbar_type("GTK_TOOLBAR_CHILD_BUTTON");
	 	
         if (w2.Class()=="GtkButton") {}
         else if (w2.Class()=="GtkToggleButton") 
            toolbar_type="GTK_TOOLBAR_CHILD_TOGGLEBUTTON";
         else if (w2.Class()=="GtkRadioButton") 
            toolbar_type="GTK_TOOLBAR_CHILD_RADIOBUTTON";
         else
            continue; // we will add it later
            
         const ChildParamList ch=w2.get_Child_params();
         if (ch.getBool("new_group"))
         {  f.Statement() << instance(w) << "tools().push_back(Gtk::Toolbar_Helpers::Space())";
         }
         if (w2.getString("cxx_visibility","private")=="private") // && CanBeManaged(w2))
	    f.Declaration() << wr2.TypeName(w2) << " *";
	 else 
	    f.Statement();
         f << Configuration.InstanceName(w2.Name()) << " = ";
         f << "Gtk::wrap((" << wr2.GtkName(w2) << "*)";
         w2.markManaged();
         f << "gtk_toolbar_append_element" 
         	   "(GTK_TOOLBAR("<< instance(w) << "gtkobj()), "
         	<< toolbar_type << ", "
         	   "0" // widget
         	   ", " << Configuration.Translatable(label) << ", " // text
         	   "0, " // tooltip text
         	   "0, " // tooltip_private_text
         	;
         if (stock_pixmap.size())
             f << "GTK_WIDGET(gnome_stock_pixmap_widget(GTK_WIDGET(" 
         	<< instance(w) << "gtkobj()), " // window, is this wrong?
                << stock_pixmap << ")), ";
         else if (icon.size() && isXPM(icon))
             f << "GTK_WIDGET(manage(new "<< GtkPrefix() << "Pixmap(" 
             	<< Naming::ToCIdentifier(icon) << "))->gtkobj()), ";
         else if (icon.size())
         {  std::cerr << "non .xpm icons are not implemented, yet\n";
            f << "0, ";
         }
         else f << "0, "; // pixmap
         f << "0, 0))"; // callback, user_data
       }
       else // yes I know, this is AddChildren but then it would get out
       	// of order
       { f.Statement() << instance(w)
       		<< "tools().push_back(Gtk::Toolbar_Helpers::WidgetElem("
       		<< Reference(w2) << "))";
       	// tooltip_text?
       }        
      }
   }
}

Subwidget Gtk_Toolbar::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="Toolbar:button") 
   {  if (ch.begin()!=ch.end()) return not_Subwidget; // constructs itself
      return is_Subwidget_all;
   }
//   std::cerr << "Toolbar with strange child "<< ch.Name() << '\n';
   return not_Subwidget;
}

void Gtk_Toolbar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int space_size(w.getInt("space_size"));
   if (space_size)
      f.Statement() << instance << "set_space_size(" << space_size << ')';
   bool tooltips(w.getBool("tooltips"));
   if (tooltips)
      f.Statement() << instance << "set_tooltips(" << PRINT_BOOL(tooltips) << ')';
   const std::string relief(w.getString("relief","GTK_RELIEF_NORMAL"));
   if (relief!="GTK_RELIEF_NORMAL")
      f.Statement() << instance << "set_button_relief(" << relief << ')';
   const std::string space_style(w.getString("space_style","GTK_TOOLBAR_SPACE_EMPTY"));
   if (space_style!="GTK_TOOLBAR_SPACE_EMPTY")
      f.Statement() << instance << "set_space_style(" << space_style << ')';
}

void Gtk_Toolbar::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const
{  Parent::AdditionalMemberVars(w,f,container);
                     
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  const Widget w2(*i);
         LookupWriter(w2).GHDeclaration(w2,f);
      }
   }
}

void Gtk_Toolbar::DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  const Widget w2(*i);
         LookupWriter(w2).DestroyPointer(w2,f);
      }
   }
   Parent::DestroyPointer_Toplevel(w,f);
}

void Gtk_Toolbar::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   Widget w(&t);
   for (Widget::iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && IsSubwidget(w,*i)!=not_Subwidget)
      {  Widget w2(*i);
         WriterBase::ApplyPreferences(const_cast<Tag&>(w2.getTag()));
         if (!Configuration.gnome_support && w2.hasTag("stock_pixmap"))
         {  Configuration.gnome_support=true;
            std::cerr << "Stock Pixmaps need gnome_support, please turn it on\n";
         }
      }
   }
}

void Gtk_Toolbar::GCInclude(const Widget &w, CxxFile &f) const
{  if (Configuration.gnome_support) // cheap assertion, doesn't hurt
      f.Include("libgnomeui/gnome-stock.h");
   // look for .xpm items in the buttons to include
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder" && ((*i).ChildName()=="Toolbar:button"))
      {const Widget w2(*i);
       if (IsSubwidget(w,*i)!=not_Subwidget)
       {  const std::string icon(w2.getString("icon"));
          if (icon.size() && isXPM(icon))
          {  f.Include("gtk--/pixmap.h");
             f.Include(Configuration.CString(Configuration.pixmap_dir_relative_to_src+"/"+icon),true);
          }
       }
      }
   }
   Parent::GCInclude(w,f);
}

const std::string Gtk_Toolbar::Instance(const Widget &parent,const Widget &w2, Subwidget sw) const
{  if (w2.Class()=="Placeholder") return "";
   return Configuration.InstanceName(w2.Name())+"->";
}

bool Gtk_Toolbar::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char *prefix("gtk_toolbar_");
   const int plen(sizeof(prefix)-1);
   if (!strncmp(prefix,method.c_str(),plen))
      method=std::string(method.c_str()+plen);
// not in 1.2   if (((method=="append_space" ||method=="prepend_space") && !args.size())
   if (((method=="set_tooltips") && matches("bool\\ \\_",args))
	|| ((method=="set_space_size") 
		&& (matches("gint\\ \\_",args)||matches("int\\ \\_",args))))
   {  scope=Gtk_Toolbar::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

bool Gtk_Toolbar::isXPM(const std::string &file) const
{  size_t sz=file.size();
   return sz>4 && file[sz-4]=='.' && file[sz-3]=='x' && file[sz-2]=='p'
   	&& file[sz-1]=='m';
}
