// $Id: notebook.cc,v 1.29 2002/02/25 14:58:12 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Notebook : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
//	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	Gtk_Notebook();
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
	const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const;
};

static Gtk_Notebook Gtk_Notebook;

const std::string Gtk_Notebook::TypeName(const Widget &w) const
{  return GtkPrefix()+"Notebook";
}

const std::string Gtk_Notebook::IncludeName(const Widget &w) const
{  return "gtk--/notebook.h";
}

Gtk_Notebook::Gtk_Notebook()
{  Writer["GtkNotebook"]=this;
}

void Gtk_Notebook::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   bool show_tabs=w.getBool("show_tabs",true);
   bool show_border=w.getBool("show_border",true);
   std::string tab_pos=w.getString("tab_pos","GTK_POS_TOP");
   bool scrollable=w.getBool("scrollable",false);
   int tab_border=w.getInt("tab_border",3);
   bool popup_enable=w.getBool("popup_enable",false);
   
   if (show_tabs)
      f.Statement() << instance << "set_show_tabs(" << PRINT_BOOL(show_tabs) << ')';
   if (!show_border)
      f.Statement() << instance << "set_show_border(" << PRINT_BOOL(show_border) << ')';
   if (scrollable)
      f.Statement() << instance << "set_scrollable(" << PRINT_BOOL(scrollable) << ')';
   if (popup_enable)
      f.Statement() << instance << (popup_enable?"popup_enable":"popup_disable") << "()";
   f.Statement() << instance << "set_tab_border(" << tab_border << ')';
   if (tab_pos!="GTK_POS_TOP")
      f.Statement() << instance << "set_tab_pos(" << tab_pos << ')';
}

void Gtk_Notebook::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{  Widget::const_iterator label=w.begin();
   Widget::const_iterator i=w.begin();
   for (;i!=w.end() && label!=w.end();++i,++label)
   {  while (i!=w.end() && (*i).hasTag("child_name")) ++i;
      if (i==w.end()) 
      {  std::cerr << w.Name() << ": more tabs than widgets, omitting tabs\n";
         break;
      }
      while (label!=w.end() && !(*label).hasTag("child_name")) ++label;
      if (label==w.end()) 
      {  std::cerr << w.Name() << ": more widgets than tabs, omitting widgets\n";
         break;
      }
      if ((*i).Class()=="Placeholder")
      {  std::cerr << w.Name() << ": empty pages are not yet supported.\n"
      		"\tPlease add an empty label\n";
      	 exit(20);
      }
      f.Statement() << instance << "pages().push_back(Gtk::Notebook_Helpers::TabElem(" 
           << Reference(*i) << ", " << Reference(*label) << "))";
   }
}

const std::string Gtk_Notebook::InternalInstance(const Widget &parent,const Widget &w2) const
{  // we can't configure the tabs
   return Parent::InternalInstance(parent,w2);
}

bool Gtk_Notebook::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char *prefix("gtk_notebook_");
   const int plen(sizeof(prefix)-1);
   if (!strncmp(prefix,method.c_str(),plen))
      method=std::string(method.c_str()+plen);
   if ((method=="next_page" && !args.size())
	|| ((method=="prev_page" ||method=="popup_enable"||method=="popup_disable")
		 && !args.size())
	|| ((method=="set_show_tabs"||method=="set_show_border"
		||method=="set_scrollable"||method=="set_homogeneous_tabs")
		 && matches("bool\\ \\_",args))
	|| ((method=="set_page"||method=="set_tab_border"
		||method=="set_tab_hborder"||method=="set_tab_vborder")
	         && (matches("gint\\ \\_",args)||matches("int\\ \\_",args))))
   {  scope=Gtk_Notebook::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

const std::string Gtk_Notebook::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="switch_page") 
      return "Gtk::Notebook_Helpers::Page *p0, guint p1";
   return Parent::SignalHandlerArgs(w,signal,rettype);
}
