// $Id: gnome_druidpagefinish.cc,v 1.3 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_druidpage.hh"

class Gnome_DruidPageFinish : public Gnome_DruidPage
{public:
	typedef Gnome_DruidPage Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_DruidPageFinish();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gnome_DruidPageFinish Gnome_DruidPageFinish;

const std::string Gnome_DruidPageFinish::TypeName(const Widget &w) const
{  return GnomePrefix()+"DruidPageFinish";
}

const std::string Gnome_DruidPageFinish::IncludeName(const Widget &w) const
{  return "gnome--/druid-page-finish.h";
}

Gnome_DruidPageFinish::Gnome_DruidPageFinish()
{  Writer["GnomeDruidPageFinish"]=this;
}

void Gnome_DruidPageFinish::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

bool Gnome_DruidPageFinish::NeedExplicitCtor(const Widget &w) const
{  return false; }

void Gnome_DruidPageFinish::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   const std::string text_color(w.getString("text_color"));
   const std::string textbox_color(w.getString("textbox_color"));
   const std::string watermark_image(w.getString("watermark_image"));
   const std::string text(w.getString("text"));
   
   if (text_color.size())
   	f.Statement() << instance << "set_text_color(" << PushColor(text_color) << ')';
   if (textbox_color.size())
   	f.Statement() << instance << "set_textbox_color(" << PushColor(textbox_color) << ')';
   if (watermark_image.size())
   	f.Statement() << instance << "set_watermark(Gdk_Imlib::Image(" << Configuration.CString_WithQuotes(watermark_image) << "))";
   if (text.size())
   	f.Statement() << instance << "set_text(" << Configuration.Translatable(text) << ')';
}
