// $Id: gnome_dateedit.cc,v 1.2 2002/01/21 17:22:47 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Jim Patterson, based on works copyright to Christof Petig
 *  and Adolf Petig GmbH & Co. KG.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gnome_DateEdit : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	Gnome_DateEdit();
        virtual void  GCInclude(const Widget &w, CxxFile &f) const;
	virtual const std::string IncludeName(const Widget &w) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
        virtual bool CantMemberConstruct(const Widget &w) const
        {  return true; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
        virtual void CreatePointer(const Widget &w,CxxFile &f) const;
};

static Gnome_DateEdit Gnome_DateEdit;

const std::string Gnome_DateEdit::TypeName(const Widget &w) const
{  return GnomePrefix()+"DateEdit";
}

void  Gnome_DateEdit::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   f.Include("time.h");
}

const std::string Gnome_DateEdit::IncludeName(const Widget &w) const
{  return "gnome--/dateedit.h";
}

Gnome_DateEdit::Gnome_DateEdit()
{  Writer["GnomeDateEdit"]=this;
}

void Gnome_DateEdit::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int lower_hour(w.getInt("lower_hour"));
   int upper_hour(w.getInt("upper_hour"));

   if ( (lower_hour<0) || (upper_hour>23) || (lower_hour>upper_hour) )
       std::cerr << "Warning: nonsensical values for time popup ranges for "
            << w.Name() << endl;
   
   bool show_time(w.getBool("show_time"));
   bool use_24_format(w.getBool("use_24_format"));
   bool week_start_monday(w.getBool("week_start_monday"));

   f.Statement() << instance << "set_popup_range(" << lower_hour
                 << "," << upper_hour << ')';

   std::string flags("GnomeDateEditFlags(0");
   if (show_time)
       flags += "|GNOME_DATE_EDIT_SHOW_TIME";
   if (use_24_format)
       flags += "|GNOME_DATE_EDIT_24_HR";
   if (week_start_monday)
       flags += "|GNOME_DATE_EDIT_WEEK_STARTS_ON_MONDAY";
   flags += ")";
   f.Statement() << instance << "set_flags(" << flags << ')';
}

void Gnome_DateEdit::ConstructionArgs(Widget const &w, CxxFile &f) const
{
   f.FunctionArg();

   bool show_time(w.getBool("show_time"));
   bool use_24_format(w.getBool("use_24_format"));

   f << "time(NULL)," << PRINT_BOOL(show_time) << ',' <<
       PRINT_BOOL(use_24_format);
}

void Gnome_DateEdit::CreatePointer(const Widget &w, CxxFile &f) const
{
   // Currently (Gtkmm 1.2.8) gtkmm's default constructor for Gnome::DateEdit
   // is broken.
   // see http://www.geocrawler.com/archives/3/1110/2001/8/100/6356137/
   // This is a workaround for this.
   f.Declaration() << TypeName(w) << " *";
   f << Configuration.InstanceName(w.Name());
   f.Assignment();
   f.FunctionName("manage").FunctionArg();
   w.markManaged();
   f.FunctionName("Gtk::wrap").FunctionArg();
   f.FunctionName("GNOME_DATE_EDIT").FunctionArg();
   f.FunctionName() << "gnome_date_edit_new";
   ConstructionArgs(w,f);
   f.EndLine();
   CreatePointer_Toplevel(w,f);
}

