// $Id: custom.cc,v 1.7 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

class Custom : public Gtk_Widget
{public:
	typedef Gtk_Widget Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
	Custom();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool CanBeManaged(const Widget &w) const
	{  return false; }
};

#include "label.hh"

static Custom Custom;

// 'A<T>(x)' -> 'A<T>'
const std::string Custom::TypeName(const Widget &w) const
{  std::string creation_function(w.getString("creation_function"));
   std::string::iterator bra(find(creation_function.begin(),creation_function.end(),'('));
   if (bra!=creation_function.end()) creation_function.erase(bra,creation_function.end());
   return creation_function;
}

// 'A<T>(x)' -> 'A.hh'
void Custom::GHInclude(const Widget &w, CxxFile &f) const
{  std::string creation_function(w.getString("creation_function"));
   std::string::iterator bra(find(creation_function.begin(),creation_function.end(),'('));
   std::string::iterator bra2(find(creation_function.begin(),creation_function.end(),'<'));
   if (bra2<bra) bra=bra2;
   if (bra!=creation_function.end()) creation_function.erase(bra,creation_function.end());
   f.Include(creation_function+Configuration.header_suffix,true);
}

Custom::Custom()
{  Writer["Custom"]=this;
}

// 'A<T>(x)' -> 'x' or use C tags
// fix for 'A<T>(X(y))' -> 'X(y)'
void Custom::ConstructionArgs(const Widget &w, CxxFile &f) const
{  const std::string creation_function(w.getString("creation_function"));
   std::string::const_iterator bra(find(creation_function.begin(),creation_function.end(),'('));
   if (bra!=creation_function.end())
   {  bra++;
      std::string::const_reverse_iterator ket(find(creation_function.rbegin(),std::string::const_reverse_iterator(bra),')'));
      if (*ket==')') ket++;
      f.FunctionArg() << std::string(bra,ket.base());
   }
   else 
   {  const std::string string1(w.getString("string1"));
      int int1(w.getInt("int1"));
      const std::string string2(w.getString("string2"));
      int int2(w.getInt("int2"));
      if (string1.size())
         f.FunctionArg() << Configuration.CString_WithQuotes(string1);
      if (int1)
         f.FunctionArg() << int1;
      if (string2.size())
         f.FunctionArg() << Configuration.CString_WithQuotes(string2);
      if (int2)
         f.FunctionArg() << int2;
      if (!string1.size() && !string2.size() && !int1 && !int2) f.FunctionArg();
   }
}

bool Custom::NeedExplicitCtor(const Widget &w) const
{  return true; }

