#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "defines.h"

#include "gui.h"
#include "xauth.h"

/* Write all of buf, even if write(2) is interrupted. */
ssize_t
full_write(int d, const char *buf, size_t nbytes)
{
  ssize_t r, w = 0;

  /* Loop until nbytes of buf have been written. */
  while (w < nbytes) {
    /* Keep trying until write succeeds without interruption. */
    do {
      r = write(d, buf + w, nbytes - w);
    } while (r < 0 && errno == EINTR);

    if (r < 0) {
      return -1;
    }

    w += r;
  }

  return w;
}

void
copy(const char *fn, const char *dir)
{
  int in, out;
  int r;
  char *newfn;
  char buf[BUFSIZ];

  newfn = g_strdup_printf("%s/%s", dir, g_basename(fn));

  out = open(newfn, O_WRONLY | O_CREAT | O_EXCL);
  if (out == -1) 
    {
      if (errno == EEXIST)
	gk_dialog(_("The X authority file i am trying to create for"
		    " root already exists! This is highly"
		    " suspicious!"));
      else
	gk_dialog(_("Error copying '%s' to '%s': %s"),
		  fn, dir, strerror(errno));
      
      clean_dir (dir);
      exit (1);
    }
      
  in = open(fn, O_RDONLY);
  if (in == -1)
    {
      gk_dialog(_("Error copying '%s' to '%s': %s"),
		fn, dir, strerror(errno));
      clean_dir (dir);
      exit (1);
    }
  
  while ((r = read(in, buf, BUFSIZ)) > 0) 
    {
      if (full_write(out, buf, r) == -1)
	{
	  gk_dialog(_("Error copying '%s' to '%s': %s"),
		    fn, dir, strerror(errno));
	  clean_dir (dir);
	  exit (1);
	}
    }
  
  if (r == -1)
    {
      gk_dialog(_("Error copying '%s' to '%s': %s"),
		fn, dir, strerror(errno));
      clean_dir (dir);
      exit (1);
    }

  close (in);
  close (out);

  chmod (newfn, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
  g_free (newfn);

}

void
clean_dir (const gchar *dirname)
{
  gchar *xauthname;
  
  xauthname = g_strdup_printf ("%s/.Xauthority", dirname);
  if (!unlink (xauthname))
    rmdir (dirname);
}
